/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.io.StringReader;
import java_cup.runtime.Symbol;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.CupError;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.JFlexError;
import org.eclipse.wst.xml.xpath2.processor.internal.XPathCup;
import org.eclipse.wst.xml.xpath2.processor.internal.XPathFlex;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;

public class InternalXPathParser {
    public XPath parse(String xpath, boolean isRootlessAccess) throws XPathParserException {
        XPathFlex lexer2 = new XPathFlex(new StringReader(xpath));
        try {
            XPathCup p = new XPathCup(lexer2);
            Symbol res = p.parse();
            XPath xPath2 = (XPath)res.value;
            if (isRootlessAccess) {
                xPath2.accept(new DefaultVisitor(){

                    @Override
                    public Object visit(XPathExpr e) {
                        if (e.slashes() > 0) {
                            throw new XPathParserException("Access to root node is not allowed (set by caller)", null);
                        }
                        do {
                            e.expr().accept(this);
                        } while ((e = e.next()) != null);
                        return null;
                    }
                });
            }
            return xPath2;
        }
        catch (JFlexError e) {
            throw new XPathParserException("JFlex lexer error: " + e.reason(), e);
        }
        catch (CupError e) {
            throw new XPathParserException("CUP parser error: " + e.reason(), e);
        }
        catch (StaticError e) {
            throw new XPathParserException(e.code(), e.getMessage(), e);
        }
        catch (Exception e) {
            throw new XPathParserException(e.getMessage(), e);
        }
    }
}

