/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NodeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PrimaryExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Step;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class Normalizer
implements XPathVisitor<XPathNode> {
    private StaticContext _sc;

    public Normalizer(StaticContext sc) {
        this._sc = sc;
    }

    @Override
    public XPathNode visit(XPath xp) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        Iterator<Expr> i = xp.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            Expr n = (Expr)e.accept(this);
            exprs.add(n);
        }
        return new XPath(exprs);
    }

    private void printVarExprPairs(Iterator<VarExprPair> i) {
        while (i.hasNext()) {
            VarExprPair pair = i.next();
            QName var2 = pair.varname();
            Expr e = pair.expr();
            e.accept(this);
        }
    }

    private void doForExpr(Iterator<VarExprPair> iter, Expr expr) {
        ArrayList<QName> vars = new ArrayList<QName>();
        while (iter.hasNext()) {
            VarExprPair pair = iter.next();
            QName var2 = pair.varname();
            Expr e = pair.expr();
            vars.add(var2);
            e.accept(this);
        }
        for (QName var2 : vars) {
        }
        expr.accept(this);
    }

    @Override
    public XPathNode visit(ForExpr fex) {
        ForExpr last = fex;
        Expr ret = fex.expr();
        int depth = 0;
        Iterator<VarExprPair> i = fex.iterator();
        while (i.hasNext()) {
            VarExprPair ve = i.next();
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                ForExpr fe = new ForExpr(pairs, ret);
                last.set_expr(fe);
                last = fe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            fex.truncate_pairs();
        }
        return fex;
    }

    @Override
    public XPathNode visit(QuantifiedExpr qex) {
        QuantifiedExpr last = qex;
        Expr ret = qex.expr();
        int depth = 0;
        Iterator<VarExprPair> i = qex.iterator();
        while (i.hasNext()) {
            VarExprPair ve = i.next();
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                QuantifiedExpr qe = new QuantifiedExpr(qex.type(), pairs, ret);
                last.set_expr(qe);
                last = qe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            qex.truncate_pairs();
        }
        return qex;
    }

    private void printExprs(Iterator<Expr> i) {
        while (i.hasNext()) {
            Expr e = i.next();
            e.accept(this);
        }
    }

    @Override
    public XPathNode visit(IfExpr ifex) {
        this.printExprs(ifex.iterator());
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return ifex;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    private BinExpr make_logic_expr(BinExpr e) {
        Collection<Expr> normalized = this.normalize_bin_args(e);
        Expr[] nor_arr = new Expr[2];
        int j = 0;
        Iterator<Expr> i = normalized.iterator();
        while (i.hasNext()) {
            nor_arr[j] = i.next();
            ++j;
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(nor_arr[0]);
        e.set_left(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        args.clear();
        args.add(nor_arr[1]);
        e.set_right(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        return e;
    }

    @Override
    public XPathNode visit(OrExpr orex) {
        return this.make_logic_expr(orex);
    }

    @Override
    public XPathNode visit(AndExpr andex) {
        return this.make_logic_expr(andex);
    }

    @Override
    public XPathNode visit(CmpExpr cmpex) {
        switch (cmpex.type()) {
            case 6: {
                return this.make_CmpOp(cmpex, new QName("fs", "eq", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 7: {
                return this.make_CmpOp(cmpex, new QName("fs", "ne", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 8: {
                return this.make_CmpOp(cmpex, new QName("fs", "lt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 10: {
                return this.make_CmpOp(cmpex, new QName("fs", "gt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 9: {
                return this.make_CmpOp(cmpex, new QName("fs", "le", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 11: {
                return this.make_CmpOp(cmpex, new QName("fs", "ge", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 12: {
                return this.make_function(new QName("op", "node-equal"), this.normalize_bin_args(cmpex));
            }
            case 13: {
                return this.make_function(new QName("op", "node-before"), this.normalize_bin_args(cmpex));
            }
            case 14: {
                return this.make_function(new QName("op", "node-after"), this.normalize_bin_args(cmpex));
            }
        }
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return cmpex;
    }

    private Collection<Expr> normalize_bin_args(BinExpr e) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        Expr left = (Expr)e.left().accept(this);
        Expr right = (Expr)e.right().accept(this);
        args.add(left);
        args.add(right);
        return args;
    }

    @Override
    public XPathNode visit(RangeExpr rex) {
        Collection<Expr> args = this.normalize_bin_args(rex);
        return this.make_function(new QName("op", "to", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_xpathexpr(PrimaryExpr pex) {
        FilterExpr fe = new FilterExpr(pex, new ArrayList<Collection<Expr>>());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_int_lit(int i) {
        IntegerLiteral il = new IntegerLiteral(BigInteger.valueOf(i));
        return this.make_xpathexpr(il);
    }

    private XPathExpr make_string_lit(String s2) {
        StringLiteral sl = new StringLiteral(s2);
        return this.make_xpathexpr(sl);
    }

    private XPathExpr make_convert_operand(XPathExpr arg1, XPathExpr arg2) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(arg1);
        args.add(arg2);
        return this.make_function(new QName("fs", "convert-operand", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_double_lit(double d) {
        DoubleLiteral dl = new DoubleLiteral(d);
        return this.make_xpathexpr(dl);
    }

    private XPathExpr make_convert_binop(BinExpr e, XPathExpr convarg, QName name) {
        Collection<Expr> args = this.normalize_bin_args(e);
        XPathExpr[] args_arr = new XPathExpr[2];
        int j = 0;
        Iterator<Expr> i = args.iterator();
        while (i.hasNext()) {
            args_arr[j] = (XPathExpr)i.next();
            ++j;
        }
        ArrayList<Expr> argsfname = new ArrayList<Expr>();
        for (j = 0; j < 2; ++j) {
            XPathExpr arg = this.make_convert_operand(args_arr[j], convarg);
            argsfname.add(arg);
        }
        return this.make_function(name, argsfname);
    }

    private XPathExpr make_ArithOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_double_lit(1.0), name);
    }

    private XPathExpr make_CmpOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_string_lit("string"), name);
    }

    @Override
    public XPathNode visit(AddExpr addex) {
        return this.make_ArithOp(addex, new QName("fs", "plus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(SubExpr subex) {
        return this.make_ArithOp(subex, new QName("fs", "minus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(MulExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "times", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(DivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "div", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(IDivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "idiv", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(ModExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "mod", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public XPathNode visit(UnionExpr unex) {
        Collection<Expr> args = this.normalize_bin_args(unex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public XPathNode visit(PipeExpr pipex) {
        Collection<Expr> args = this.normalize_bin_args(pipex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public XPathNode visit(IntersectExpr iexpr) {
        Collection<Expr> args = this.normalize_bin_args(iexpr);
        return this.make_function(new QName("op", "intersect", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public XPathNode visit(ExceptExpr eexpr) {
        Collection<Expr> args = this.normalize_bin_args(eexpr);
        return this.make_function(new QName("op", "except", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public XPathNode visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return ioexp;
    }

    @Override
    public XPathNode visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return taexp;
    }

    @Override
    public XPathNode visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return cexp;
    }

    @Override
    public XPathNode visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        return cexp;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    @Override
    public XPathNode visit(MinusExpr e) {
        SubExpr se = new SubExpr(this.make_int_lit(0), e.arg());
        return se.accept(this);
    }

    @Override
    public XPathNode visit(PlusExpr e) {
        AddExpr ae = new AddExpr(this.make_int_lit(0), e.arg());
        return ae.accept(this);
    }

    private XPathExpr make_function(QName name, Collection<Expr> args) {
        FunctionCall fc = new FunctionCall(name, args);
        FilterExpr fe = new FilterExpr(fc, new ArrayList<Collection<Expr>>());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_root_self_node() {
        ForwardStep self_node = new ForwardStep(4, new AnyKindTest());
        AxisStep self_node_expr = new AxisStep(self_node, new ArrayList<Collection<Expr>>());
        XPathExpr self_node_xpath = new XPathExpr(0, self_node_expr);
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(self_node_xpath);
        XPathExpr xpe = this.make_function(new QName("fn", "root", "http://www.w3.org/2005/xpath-functions"), args);
        return xpe;
    }

    private XPathExpr make_descendant_or_self() {
        ForwardStep desc_self_node = new ForwardStep(5, new AnyKindTest());
        AxisStep se = new AxisStep(desc_self_node, new ArrayList<Collection<Expr>>());
        return new XPathExpr(0, se);
    }

    @Override
    public XPathNode visit(XPathExpr e) {
        XPathExpr xp = e;
        int depth = 0;
        XPathExpr result = e;
        while (xp != null) {
            XPathExpr next;
            int slashes = xp.slashes();
            StepExpr se = xp.expr();
            if (slashes == 1) {
                if (se == null) {
                    return this.make_root_self_node();
                }
                if (depth == 0) {
                    XPathExpr xpe = this.make_root_self_node();
                    xpe.set_next(e);
                    result = xpe;
                }
            }
            if (slashes == 2 && depth == 0) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                e.set_slashes(1);
                desc.set_next(e);
                XPathExpr root_self = this.make_root_self_node();
                root_self.set_next(desc);
                return root_self;
            }
            if (se != null) {
                se.accept(this);
            }
            if ((next = xp.next()) != null && next.slashes() == 2) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                xp.set_next(desc);
                desc.set_next(next);
                next.set_slashes(1);
            }
            xp = next;
            ++depth;
        }
        return result;
    }

    @Override
    public XPathNode visit(ForwardStep e) {
        int axis = e.axis();
        switch (axis) {
            case 9: {
                e.set_axis(3);
                break;
            }
            case 0: {
                e.set_axis(1);
            }
        }
        e.node_test().accept(this);
        return e;
    }

    @Override
    public XPathNode visit(ReverseStep e) {
        if (e.axis() == 5) {
            AnyKindTest nt = new AnyKindTest();
            ReverseStep s2 = new ReverseStep(0, nt);
            return s2;
        }
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        return e;
    }

    @Override
    public XPathNode visit(NameTest e) {
        String prefix = e.name().prefix();
        if (prefix == null) {
            return null;
        }
        return e;
    }

    @Override
    public XPathNode visit(VarRef e) {
        return e;
    }

    @Override
    public XPathNode visit(StringLiteral e) {
        return e;
    }

    @Override
    public XPathNode visit(IntegerLiteral e) {
        return e;
    }

    @Override
    public XPathNode visit(DoubleLiteral e) {
        return e;
    }

    @Override
    public XPathNode visit(DecimalLiteral e) {
        return e;
    }

    @Override
    public XPathNode visit(ParExpr e) {
        this.printExprs(e.iterator());
        return e;
    }

    @Override
    public XPathNode visit(CntxItemExpr e) {
        return new VarRef(new QName("fs", "dot"));
    }

    @Override
    public XPathNode visit(FunctionCall e) {
        this.printExprs(e.iterator());
        return e;
    }

    @Override
    public XPathNode visit(SingleType e) {
        return e;
    }

    @Override
    public XPathNode visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return e;
    }

    @Override
    public XPathNode visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return e;
    }

    @Override
    public XPathNode visit(AnyKindTest e) {
        return e;
    }

    @Override
    public XPathNode visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return e;
    }

    @Override
    public XPathNode visit(TextTest e) {
        return e;
    }

    @Override
    public XPathNode visit(CommentTest e) {
        return e;
    }

    @Override
    public XPathNode visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return e;
    }

    @Override
    public XPathNode visit(AttributeTest e) {
        return e;
    }

    @Override
    public XPathNode visit(SchemaAttrTest e) {
        return e;
    }

    @Override
    public XPathNode visit(ElementTest e) {
        return e;
    }

    @Override
    public XPathNode visit(SchemaElemTest e) {
        return e;
    }

    private void printCollExprs(Iterator<Collection<Expr>> i) {
        while (i.hasNext()) {
            Collection<Expr> exprs = i.next();
            this.printExprs(exprs.iterator());
        }
    }

    @Override
    public XPathNode visit(AxisStep e) {
        Step s2 = (Step)e.step().accept(this);
        e.set_step(s2);
        this.printCollExprs(e.iterator());
        return e;
    }

    @Override
    public XPathNode visit(FilterExpr e) {
        PrimaryExpr pe = (PrimaryExpr)e.primary().accept(this);
        e.set_primary(pe);
        this.printCollExprs(e.iterator());
        return e;
    }
}

