/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.AbstractCollationEqualFunction;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Node;

public class FnDeepEqual
extends AbstractCollationEqualFunction {
    public FnDeepEqual() {
        super(new QName("deep-equal"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnDeepEqual.deep_equal(args, ec);
    }

    public static ResultSequence deep_equal(Collection<ResultSequence> args, EvaluationContext context) throws DynamicError {
        Iterator<ResultSequence> citer = args.iterator();
        ResultSequence arg1 = citer.next();
        ResultSequence arg2 = citer.next();
        ResultSequence arg3 = null;
        String collationURI = context.getStaticContext().getCollationProvider().getDefaultCollation();
        if (citer.hasNext() && !(arg3 = citer.next()).empty()) {
            collationURI = arg3.first().getStringValue();
        }
        boolean result = FnDeepEqual.deep_equal(arg1, arg2, context, collationURI);
        return ResultSequenceFactory.create_new(new XSBoolean(result));
    }

    public static boolean deep_equal(ResultSequence one, ResultSequence two, EvaluationContext context, String collationURI) {
        if (one.empty() && two.empty()) {
            return true;
        }
        if (one.size() != two.size()) {
            return false;
        }
        Iterator<Item> onei = one.iterator();
        Iterator<Item> twoi = two.iterator();
        while (onei.hasNext()) {
            AnyType b;
            AnyType a = (AnyType)onei.next();
            if (FnDeepEqual.deep_equal(a, b = (AnyType)twoi.next(), context, collationURI)) continue;
            return false;
        }
        return true;
    }

    public static boolean deep_equal(AnyType one, AnyType two, EvaluationContext context, String collationURI) {
        if (one instanceof AnyAtomicType && two instanceof AnyAtomicType) {
            return FnDeepEqual.deep_equal_atomic((AnyAtomicType)one, (AnyAtomicType)two, context.getDynamicContext(), collationURI);
        }
        if (one instanceof AnyAtomicType && two instanceof NodeType || one instanceof NodeType && two instanceof AnyAtomicType) {
            return false;
        }
        if (one instanceof NodeType && two instanceof NodeType) {
            return FnDeepEqual.deep_equal_node((NodeType)one, (NodeType)two, context);
        }
        return false;
    }

    public static boolean deep_equal_atomic(AnyAtomicType one, AnyAtomicType two, DynamicContext context, String collationURI) {
        if (!(one instanceof CmpEq)) {
            return false;
        }
        if (!(two instanceof CmpEq)) {
            return false;
        }
        CmpEq a = (CmpEq)((Object)one);
        try {
            XSString xstr2;
            XSString xstr1;
            if (FnDeepEqual.isNumeric(one, (AnyType)two)) {
                NumericType numeric = (NumericType)one;
                if (numeric.eq(two, context)) {
                    return true;
                }
                XSString value1 = new XSString(one.getStringValue());
                if (value1.eq(two, context)) {
                    return true;
                }
            }
            if (a.eq(two, context)) {
                return true;
            }
            return FnDeepEqual.needsStringComparison(one, (AnyType)two) && FnCompare.compare_string(collationURI, xstr1 = new XSString(one.getStringValue()), xstr2 = new XSString(two.getStringValue()), context).equals(BigInteger.ZERO);
        }
        catch (DynamicError err) {
            return false;
        }
    }

    public static boolean deep_equal_node(NodeType one, NodeType two, EvaluationContext context) {
        Node b;
        Node a = one.node_value();
        return a.isEqualNode(b = two.node_value());
    }
}

