/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class QName
extends CtrType
implements CmpEq {
    private static final String XS_Q_NAME = "xs:QName";
    private String _namespace;
    private String _prefix;
    private String _local_part;
    private boolean _expanded;

    public QName(String prefix, String local_part, String ns) {
        this(prefix, local_part);
        this.set_namespace(ns);
    }

    public QName(String prefix, String local_part) {
        this._prefix = prefix;
        this._local_part = local_part;
        this._expanded = false;
    }

    public QName(String local_part) {
        this(null, local_part);
        this.set_namespace(null);
    }

    public QName() {
        this(null, null);
    }

    public QName(javax.xml.namespace.QName name) {
        this("".equals(name.getPrefix()) ? null : name.getPrefix(), name.getLocalPart());
        if (!"".equals(name.getNamespaceURI())) {
            this.set_namespace(name.getNamespaceURI());
        }
        this._expanded = true;
    }

    public static QName parse_QName(String str) {
        int occurs = 0;
        char[] strChrArr = str.toCharArray();
        for (int chrIndx = 0; chrIndx < strChrArr.length; ++chrIndx) {
            if (strChrArr[chrIndx] != ':') continue;
            ++occurs;
        }
        if (occurs > 1) {
            return null;
        }
        String[] tokens = str.split(":");
        if (tokens.length == 1) {
            return new QName(tokens[0]);
        }
        if (tokens.length == 2) {
            return new QName(tokens[0], tokens[1]);
        }
        return null;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        String sarg;
        QName qname;
        AnyAtomicType aat;
        if (arg.empty()) {
            DynamicError.throw_type_error();
        }
        if (!((aat = (AnyAtomicType)arg.first()) instanceof XSString) && !(aat instanceof QName)) {
            DynamicError.throw_type_error();
        }
        if ((qname = QName.parse_QName(sarg = aat.getStringValue())) == null) {
            return null;
        }
        return qname;
    }

    @Override
    public String getStringValue() {
        return this.string();
    }

    @Override
    public String string_type() {
        return XS_Q_NAME;
    }

    @Override
    public String type_name() {
        return "QName";
    }

    public String string() {
        String res = "";
        if (this._prefix != null) {
            res = this._prefix + ":";
        }
        res = res + this._local_part;
        return res;
    }

    public String expanded_name() {
        assert (this._expanded);
        String e = "";
        if (this._namespace != null) {
            e = e + this._namespace + ":";
        }
        return e + this._local_part;
    }

    public String prefix() {
        return this._prefix;
    }

    public void set_namespace(String n) {
        this._namespace = n != null ? (n.length() == 0 ? null : n) : null;
        this._expanded = true;
    }

    public String namespace() {
        assert (this._expanded);
        return this._namespace;
    }

    public String local() {
        return this._local_part;
    }

    public boolean expanded() {
        return this._expanded;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QName)) {
            return false;
        }
        QName arg = (QName)obj;
        if (!this._expanded || !arg.expanded()) {
            assert (false);
            return false;
        }
        String argn = arg.namespace();
        if (this._namespace != null ? !this._namespace.equals(argn) : argn != null) {
            return false;
        }
        String argl = arg.local();
        return !(this._local_part != null ? !this._local_part.equals(argl) : argl != null);
    }

    public int hashCode() {
        int namespace = 3;
        int local = 4;
        int result = 0;
        assert (this.expanded());
        if (this._namespace != null) {
            namespace = this._namespace.hashCode();
        }
        if (this._local_part != null) {
            local = this._local_part.hashCode();
        }
        result = namespace;
        result ^= 2 * local;
        if (this._expanded) {
            result ^= result + 1;
        }
        return result;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        QName val2 = (QName)NumericType.get_single_type(arg, QName.class);
        return this.equals(val2);
    }

    public String toString() {
        return this.string();
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_QNAME;
    }

    public javax.xml.namespace.QName asQName() {
        return new javax.xml.namespace.QName(this.namespace(), this.local(), this.prefix() != null ? this.prefix() : "");
    }

    @Override
    public Object getNativeValue() {
        return this.asQName();
    }
}

