/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSLong
extends XSInteger {
    private static final String XS_LONG = "xs:long";

    public XSLong() {
        this(BigInteger.valueOf(0L));
    }

    public XSLong(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_LONG;
    }

    @Override
    public String type_name() {
        return "long";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min2 = BigInteger.valueOf(Long.MIN_VALUE);
            BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
            if (bigInt.compareTo(min2) < 0 || bigInt.compareTo(max) > 0) {
                DynamicError.throw_type_error();
            }
            return new XSLong(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null, e);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_LONG;
    }
}

