/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.model.domain.Encoding;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.domain.PropertyShape;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.Example;
import amf.shapes.client.platform.model.domain.NodeShape;
import amf.shapes.client.platform.model.domain.UnionShape;
import amf.xml.client.platform.plugin.XmlValidationPlugin;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.amf.impl.model.MediaType;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.parser.rule.ApiValidationResultImpl;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.apikit.validation.ApiValidationResult;
import org.mule.apikit.validation.ExceptionApiValidationResult;

public class MimeTypeImpl
implements MimeType {
    private final Payload payload;
    private final Shape shape;
    private final Map<String, AMFShapePayloadValidator> payloadValidatorMap = new ConcurrentHashMap<String, AMFShapePayloadValidator>();
    private final String defaultMediaType;
    private final AMFConfiguration amfConfiguration;
    private Map<String, List<Parameter>> formParameters;

    public MimeTypeImpl(Payload payload, AMFConfiguration amfConfiguration) {
        this.payload = payload;
        this.shape = payload.schema();
        this.defaultMediaType = this.payload.mediaType().option().orElse(null);
        this.amfConfiguration = amfConfiguration;
    }

    @Override
    public Object getCompiledSchema() {
        return null;
    }

    @Override
    public String getSchema() {
        if (this.shape.getClass() == AnyShape.class) {
            return null;
        }
        if (this.shape instanceof AnyShape) {
            return this.amfConfiguration.elementClient().buildJsonSchema((AnyShape)this.shape);
        }
        return null;
    }

    @Override
    public Map<String, List<Parameter>> getFormParameters() {
        if (MapUtils.isNotEmpty(this.formParameters)) {
            return this.formParameters;
        }
        String mediaType = this.payload.mediaType().value();
        if (mediaType.startsWith("multipart/form-data") || mediaType.equals("application/x-www-form-urlencoded")) {
            if (!(this.shape instanceof NodeShape)) {
                return Collections.emptyMap();
            }
            NodeShape nodeShape = (NodeShape)this.shape;
            Map<String, Set<String>> formParametersEncoding = this.getFormParametersEncoding();
            this.formParameters = new LinkedHashMap<String, List<Parameter>>();
            for (PropertyShape propertyShape : nodeShape.properties()) {
                String propertyName = propertyShape.name().value();
                this.formParameters.put(propertyName, Collections.singletonList(new ParameterImpl(propertyShape, formParametersEncoding.get(propertyName), this.amfConfiguration)));
            }
            return this.formParameters;
        }
        return Collections.emptyMap();
    }

    @Override
    public String getType() {
        return this.payload.mediaType().value();
    }

    @Override
    public String getExample() {
        List<Example> examplesList;
        if (this.shape instanceof UnionShape) {
            UnionShape unionShape = (UnionShape)this.shape;
            for (Shape shape : unionShape.anyOf()) {
                String example;
                if (!(shape instanceof AnyShape) || (example = this.getExampleFromAnyShape((AnyShape)shape)) == null) continue;
                return example;
            }
        }
        if (this.shape instanceof AnyShape) {
            return this.getExampleFromAnyShape((AnyShape)this.shape);
        }
        if (this.shape == null && CollectionUtils.isNotEmpty(examplesList = this.payload.examples())) {
            return this.getExampleValueByMediaType(examplesList.get(0));
        }
        return null;
    }

    private String getExampleFromAnyShape(AnyShape anyShape) {
        Example example2;
        Optional<Example> trackedExample = anyShape.trackedExample(this.payload.id());
        if (trackedExample.isPresent() && (example2 = trackedExample.get()).value().nonNull()) {
            return this.getExampleValueByMediaType(example2);
        }
        return anyShape.examples().stream().filter(example -> example.value().value() != null).map(example -> this.getExampleValueByMediaType((Example)example)).findFirst().orElse(null);
    }

    private String getExampleValueByMediaType(Example example) {
        String mimeType = ObjectUtils.firstNonNull(this.getType(), this.defaultMediaType);
        if ("application/json".equals(mimeType) || "application/yaml".equals(mimeType)) {
            return this.amfConfiguration.elementClient().renderExample(example, mimeType);
        }
        return example.value().value();
    }

    @Override
    public Object getInstance() {
        return null;
    }

    @Override
    public List<ApiValidationResult> validate(String payload) {
        String mimeType = MediaType.getMimeTypeForValue(payload);
        AMFShapePayloadValidator payloadValidator = this.payloadValidatorMap.computeIfAbsent(mimeType, payloadMimeType -> this.getPayloadValidator((String)payloadMimeType));
        if (payloadValidator != null) {
            return MimeTypeImpl.mapToValidationResult(payloadValidator.syncValidate(payload));
        }
        return ImmutableList.of(new ExceptionApiValidationResult(new RuntimeException(String.format("Validator not found for %s", mimeType))));
    }

    private AMFShapePayloadValidator getPayloadValidator(String mediaType) {
        return this.amfConfiguration.withShapePayloadPlugin(new XmlValidationPlugin()).elementClient().payloadValidatorFor(this.shape, mediaType, ValidationMode.StrictValidationMode());
    }

    private static List<ApiValidationResult> mapToValidationResult(AMFValidationReport validationReport) {
        if (validationReport.conforms()) {
            return Collections.emptyList();
        }
        return validationReport.results().stream().map(ApiValidationResultImpl::new).collect(Collectors.toList());
    }

    private Map<String, Set<String>> getFormParametersEncoding() {
        LinkedHashMap<String, Set<String>> formParametersEncoding = new LinkedHashMap<String, Set<String>>();
        List<Encoding> encodingList = this.payload.encoding();
        if (CollectionUtils.isNotEmpty(encodingList)) {
            encodingList.forEach(e -> formParametersEncoding.put(e.propertyName().value(), this.getContentTypeSet(e.contentType().value())));
        }
        return formParametersEncoding;
    }

    private Set<String> getContentTypeSet(String contentTypeCSV) {
        String[] contentTypes = contentTypeCSV.split(",");
        HashSet<String> contentTypeSet = new HashSet<String>();
        for (String contentType : contentTypes) {
            contentTypeSet.add(contentType.trim());
        }
        return contentTypeSet;
    }
}

