/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.AMFImpl;
import org.mule.amf.impl.model.ActionImpl;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.parameter.Parameter;

public class ResourceImpl
implements Resource {
    private static final String VERSION = "version";
    private static final Predicate<amf.apicontract.client.platform.model.domain.Parameter> IS_NOT_VERSION = p -> !VERSION.equals(p.parameterName().value());
    private final AMFConfiguration amfConfiguration;
    private AMFImpl amf;
    private EndPoint endPoint;
    private Map<ActionType, Action> actions;
    private Map<String, Parameter> resolvedUriParameters;

    ResourceImpl(AMFImpl amf, EndPoint endPoint, AMFConfiguration amfConfiguration) {
        this.amf = amf;
        this.endPoint = endPoint;
        this.amfConfiguration = amfConfiguration;
    }

    @Override
    public String getRelativeUri() {
        return this.endPoint.relativePath();
    }

    @Override
    public String getUri() {
        return this.endPoint.path().value();
    }

    @Override
    public String getResolvedUri(String version2) {
        return ParserUtils.resolveVersion(this.getUri(), version2);
    }

    @Override
    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    @Override
    public Action getAction(String name) {
        return this.getActions().get((Object)ResourceImpl.getActionKey(name));
    }

    @Override
    public Map<ActionType, Action> getActions() {
        if (this.actions == null) {
            this.actions = this.loadActions(this.endPoint);
        }
        return this.actions;
    }

    private Map<ActionType, Action> loadActions(EndPoint endPoint) {
        LinkedHashMap<ActionType, Action> map = new LinkedHashMap<ActionType, Action>();
        endPoint.operations().forEach(operation -> {
            Action cfr_ignored_0 = map.put(ResourceImpl.getActionKey(operation.method().value()), new ActionImpl(this, (Operation)operation));
        });
        return map;
    }

    private static ActionType getActionKey(String method) {
        return ActionType.valueOf(method.toUpperCase());
    }

    @Override
    public Map<String, Resource> getResources() {
        return this.amf.getResources(this);
    }

    @Override
    public String getDisplayName() {
        String value = this.endPoint.name().value();
        return value != null ? value : this.getRelativeUri();
    }

    @Override
    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.endPoint, this.amfConfiguration);
        }
        return this.resolvedUriParameters;
    }

    private static Map<String, Parameter> loadResolvedUriParameters(EndPoint resource, AMFConfiguration amfConfiguration) {
        return resource.parameters().stream().filter(IS_NOT_VERSION).collect(Collectors.toMap(p -> p.parameterName().value(), p -> new ParameterImpl((amf.apicontract.client.platform.model.domain.Parameter)p, amfConfiguration)));
    }

    @Override
    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }

    public AMFConfiguration getAmfConfiguration() {
        return this.amfConfiguration;
    }
}

