/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.util;

import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;

public class LazyValue<T>
implements Supplier<T> {
    private volatile boolean initialized = false;
    private T value;
    private Supplier<T> valueSupplier;

    public LazyValue(Supplier<T> supplier) {
        Validate.notNull(supplier, "supplier cannot be null", new Object[0]);
        this.valueSupplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                if (!this.initialized) {
                    this.value = this.valueSupplier.get();
                    this.valueSupplier = null;
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }
}

