/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit;

import java.util.Collection;
import java.util.Map;
import org.mule.apikit.model.parameter.Parameter;

public class ParserUtils {
    public static String resolveVersion(String path, String version2) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (!path.contains("{version}")) {
            return path;
        }
        if (version2 == null) {
            throw new IllegalStateException("RAML does not contain version information and is required by resource: " + path);
        }
        return path.replaceAll("\\{version}", version2);
    }

    public static String getArrayAsYamlValue(Parameter facet, Collection<?> paramValues) {
        if (paramValues == null || facet.isNullable() && ParserUtils.isNull(paramValues)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        paramValues.forEach(paramValue -> {
            String value = ParserUtils.valueOfPreservingNull(paramValue);
            builder.append("- ");
            builder.append(facet.surroundWithQuotesIfNeeded(value));
            builder.append("\n");
        });
        return builder.toString();
    }

    public static String queryStringAsYamlValue(Map<String, Parameter> facets, Map<String, Collection<?>> queryParamsCopy) {
        StringBuilder queryStringYaml = new StringBuilder();
        for (String property : queryParamsCopy.keySet()) {
            Parameter facet = facets.get(property.toString());
            if (facet == null) {
                return "";
            }
            Collection<?> actualQueryParam = queryParamsCopy.get(property.toString());
            queryStringYaml.append("\n").append((Object)property).append(": ");
            if (actualQueryParam == null || facet.isNullable() && ParserUtils.isNull(actualQueryParam)) {
                queryStringYaml.append(facet.surroundWithQuotesIfNeeded(null)).append("\n");
                continue;
            }
            if (actualQueryParam.size() > 1 || facet.isArray()) {
                for (Object value : actualQueryParam) {
                    queryStringYaml.append("\n  - ").append(facet.surroundWithQuotesIfNeeded(ParserUtils.valueOfPreservingNull(value)));
                }
                queryStringYaml.append("\n");
                continue;
            }
            for (Object value : actualQueryParam) {
                queryStringYaml.append(facet.surroundWithQuotesIfNeeded(ParserUtils.valueOfPreservingNull(value))).append("\n");
            }
        }
        return queryStringYaml.toString();
    }

    private static boolean isNull(Collection<?> paramValues) {
        return paramValues == null || paramValues.size() == 1 && paramValues.stream().allMatch(value -> value == null || "null".equals(value));
    }

    private static String valueOfPreservingNull(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    public static String quoteValue(String payload) {
        return "\"" + payload + "\"";
    }

    public static String escapeSpecialCharsInYamlValue(String value) {
        return value == null ? null : value.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

