/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv1;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.raml.model.parameter.AbstractParam;

public class MetadataResolver {
    private static final MetadataType STRING_METADATA_TYPE = BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().build();

    private MetadataResolver() {
    }

    public static Optional<MetadataType> resolve(AbstractParam param2) {
        TypeBuilder builder;
        BaseTypeBuilder rootBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        switch (param2.getType()) {
            case NUMBER: {
                builder = MetadataResolver.handle(rootBuilder.numberType(), param2);
                break;
            }
            case INTEGER: {
                builder = MetadataResolver.handle(rootBuilder.numberType().integer(), param2);
                break;
            }
            case BOOLEAN: {
                builder = MetadataResolver.handle(rootBuilder.booleanType(), param2);
                break;
            }
            default: {
                builder = MetadataResolver.handle(rootBuilder.stringType(), param2);
            }
        }
        Object metadataType = param2.isRepeat() ? rootBuilder.arrayType().of((MetadataType)builder.build()).build() : builder.build();
        return Optional.of(metadataType);
    }

    private static TypeBuilder handle(BooleanTypeBuilder builder, AbstractParam param2) {
        Optional.ofNullable(param2.getDefaultValue()).ifPresent(builder::defaultValue);
        return builder;
    }

    private static TypeBuilder handle(StringTypeBuilder builder, AbstractParam param2) {
        List<String> enumValues = param2.getEnumeration();
        if (enumValues != null && !enumValues.isEmpty()) {
            builder.enumOf(enumValues.toArray(new String[enumValues.size()]));
        }
        Optional<Integer> minLength = Optional.ofNullable(param2.getMinLength());
        Optional<Integer> maxLength = Optional.ofNullable(param2.getMaxLength());
        if (minLength.isPresent() && maxLength.isPresent()) {
            builder.boundary(minLength.get(), maxLength.get());
        } else {
            maxLength.ifPresent(builder::length);
        }
        Optional.ofNullable(param2.getPattern()).ifPresent(builder::pattern);
        Optional.ofNullable(param2.getDefaultValue()).ifPresent(builder::defaultValue);
        return builder;
    }

    private static TypeBuilder handle(NumberTypeBuilder builder, AbstractParam param2) {
        Optional<BigDecimal> maximum = Optional.ofNullable(param2.getMaximum());
        Optional<BigDecimal> minimum = Optional.ofNullable(param2.getMinimum());
        if (maximum.isPresent() && minimum.isPresent()) {
            builder.range(minimum.get(), maximum.get());
        }
        Optional.ofNullable(param2.getDefaultValue()).ifPresent(builder::defaultValue);
        return builder;
    }

    public static MetadataType stringType() {
        return STRING_METADATA_TYPE;
    }
}

