/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv1.loader;

import java.io.InputStream;
import javax.annotation.Nullable;
import org.mule.apikit.common.ApiSyncUtils;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;

public class ApiSyncResourceLoader
implements ResourceLoader {
    private ResourceLoader resourceLoader;
    private String rootRamlResource;

    public ApiSyncResourceLoader(String rootRaml) {
        this(rootRaml, new DefaultResourceLoader());
    }

    public ApiSyncResourceLoader(String rootRaml, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.rootRamlResource = this.getRootRamlResource(rootRaml);
    }

    private String getRootRamlResource(String rootRamlResource) {
        return rootRamlResource.substring(0, rootRamlResource.lastIndexOf(":") + 1);
    }

    @Override
    @Nullable
    public InputStream fetchResource(String s2) {
        InputStream stream = null;
        if (s2.startsWith("/")) {
            s2 = s2.substring(1);
        }
        if (ApiSyncUtils.isExchangeModules(s2)) {
            stream = this.getApiSyncResource(s2);
        }
        if (stream != null) {
            return stream;
        }
        if (ApiSyncUtils.isSyncProtocol(s2)) {
            return this.resourceLoader.fetchResource(s2);
        }
        return this.resourceLoader.fetchResource(this.rootRamlResource + s2);
    }

    private InputStream getApiSyncResource(String s2) {
        String apiSyncResource = ApiSyncUtils.toApiSyncResource(s2);
        if (apiSyncResource != null) {
            return this.resourceLoader.fetchResource(apiSyncResource);
        }
        return null;
    }
}

