/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.implv2.v10.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ParserUtils;
import org.mule.apikit.implv2.v10.model.ActionImpl;
import org.mule.apikit.implv2.v10.model.ParameterImpl;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.parameter.Parameter;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class ResourceImpl
implements org.mule.apikit.model.Resource {
    private Resource resource;
    private Map<ActionType, Action> actions;
    private Map<String, Parameter> resolvedUriParameters;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getRelativeUri() {
        return this.resource.relativeUri().value();
    }

    @Override
    public String getUri() {
        return this.resource.resourcePath();
    }

    @Override
    public String getResolvedUri(String version2) {
        return ParserUtils.resolveVersion(this.getUri(), version2);
    }

    @Override
    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    @Override
    public Action getAction(String name) {
        return this.getActions().get((Object)ResourceImpl.getActionKey(name));
    }

    @Override
    public Map<ActionType, Action> getActions() {
        if (this.actions == null) {
            this.actions = ResourceImpl.loadActions(this.resource);
        }
        return this.actions;
    }

    private static Map<ActionType, Action> loadActions(Resource resource) {
        LinkedHashMap<ActionType, Action> map = new LinkedHashMap<ActionType, Action>();
        for (Method method : resource.methods()) {
            map.put(ResourceImpl.getActionKey(method.method()), new ActionImpl(method));
        }
        return map;
    }

    private static ActionType getActionKey(String method) {
        return ActionType.valueOf(method.toUpperCase());
    }

    @Override
    public Map<String, org.mule.apikit.model.Resource> getResources() {
        HashMap<String, org.mule.apikit.model.Resource> result = new HashMap<String, org.mule.apikit.model.Resource>();
        for (Resource item : this.resource.resources()) {
            result.put(item.relativeUri().value(), new ResourceImpl(item));
        }
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.resource.displayName() != null ? String.valueOf(this.resource.displayName().value()) : null;
    }

    @Override
    public Map<String, Parameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.resource);
        }
        return this.resolvedUriParameters;
    }

    static Map<String, Parameter> loadResolvedUriParameters(Resource resource) {
        HashMap<String, Parameter> result = new HashMap<String, Parameter>();
        for (Resource current = resource; current != null; current = current.parentResource()) {
            for (TypeDeclaration typeDeclaration : current.uriParameters()) {
                result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
            }
        }
        return result;
    }

    @Override
    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<Parameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }
}

