/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.dx.platform.api.graphql.GraphQlClient;

public abstract class Dependency {
    protected final GraphQlClient client;
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\\"version\\\":\\\"(.*)\\\"");

    public Dependency(GraphQlClient client) {
        this.client = client;
    }

    private Optional<String> getVersionFromExchange(String assets) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(assets);
        return versionMatcher.find() ? Optional.of(versionMatcher.group(1)) : Optional.empty();
    }

    public abstract String groupId();

    public abstract String artifactId();

    public abstract String getDefaultVersion();

    public abstract String classifier();

    public abstract String scope();

    public String version() {
        String assets = this.client.query(this.exchangeQuery(), Optional.empty());
        return this.getVersionFromExchange(assets).orElse(this.getDefaultVersion());
    }

    private String exchangeQuery() {
        return "{\n  asset(groupId: \"" + this.groupId() + "\", assetId: \"" + this.artifactId() + "\") {\n    version\n  }\n}";
    }
}

