/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.scaffolding.internal.APIKitScaffolder;
import org.mule.apikit.scaffolding.internal.config.ScaffoldingConfigImpl;
import org.mule.apikit.scaffolding.internal.mapper.AmfApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.AsyncApiGraphMapper;
import org.mule.apikit.scaffolding.internal.mapper.GraphQLApiGraphMapper;
import org.mule.apikit.scaffolding.internal.template.DataWeaveTemplateEngine;
import org.mule.dx.contributions.exception.ParsingException;
import org.mule.dx.contributions.exception.ScaffoldingException;
import org.mule.dx.contributions.jsonrpc.ScaffoldingService;
import org.mule.dx.contributions.scaffolding.MavenDependencyModelImpl;
import org.mule.dx.contributions.scaffolding.handler.ProjectHandler;
import org.mule.dx.contributions.scaffolding.handler.ResponseHandler;
import org.mule.dx.contributions.scaffolding.model.ScaffoldRequest;
import org.mule.dx.contributions.scaffolding.model.ScaffoldResponse;
import org.mule.dx.contributions.utils.ResourceLoaderFactory;
import org.mule.dx.platform.api.WorkspaceManager;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.tools.apikit.MainAppScaffolder;
import org.mule.tools.apikit.model.RuntimeEdition;
import org.mule.tools.apikit.model.ScaffolderContext;
import org.mule.tools.apikit.model.ScaffolderContextBuilder;
import org.mule.tools.apikit.model.ScaffoldingConfiguration;
import org.mule.tools.apikit.model.ScaffoldingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaffoldingServiceImpl
implements ScaffoldingService {
    private static final Logger logger = LoggerFactory.getLogger(ScaffoldingServiceImpl.class);
    @Inject
    private WorkspaceManager workspaceManager;
    private ProjectHandler projectHandler;
    @Inject
    private GraphQlClient graphQlClient;
    private final Set<String> legacyScaffolder = ImmutableSet.of("raml", "oas");
    private final Map<String, String> apiTypes = Map.of("evented-api", "asyncapi", "graphql", "graphql", "graphql-apollo", "graphql");
    private final Map<String, AmfApiGraphMapper> graphMappers = Map.of("evented-api", this.getAsyncApiGraphMapper(), "graphql", this.getGraphQLApiGraphMapper(), "graphql-apollo", this.getGraphQLApiGraphMapper());

    protected ResourceLoader getResourceLoader(String apiUri) {
        return ResourceLoaderFactory.getResourceLoader(apiUri);
    }

    protected GraphQLApiGraphMapper getGraphQLApiGraphMapper() {
        return new GraphQLApiGraphMapper();
    }

    protected AsyncApiGraphMapper getAsyncApiGraphMapper() {
        return new AsyncApiGraphMapper();
    }

    @Override
    public CompletableFuture<ScaffoldResponse> scaffold(ScaffoldRequest request) {
        String apiUri = request.getApiUri();
        logger.info("Got scaffolding request for {}", (Object)apiUri);
        if (StringUtils.isBlank(apiUri)) {
            return CompletableFuture.completedFuture(ResponseHandler.createErrorResponse(new Exception("API location cannot be null")));
        }
        if (this.projectHandler == null) {
            this.projectHandler = new ProjectHandler(this.workspaceManager, this.graphQlClient);
        }
        ApiReference reference = ApiReference.create(apiUri, this.getResourceLoader(apiUri));
        String projectId = request.getProjectId();
        String classifier = ScaffoldingServiceImpl.getClassifier(request.getApiUri());
        if (classifier == null) {
            return CompletableFuture.completedFuture(ResponseHandler.createErrorResponse(new Exception("Unsupported API URI. Unable to recognize API classifier.")));
        }
        return this.requestNeedsLegacyScaffolder(classifier) ? this.scaffoldWithLegacyScaffolder(reference, projectId, classifier) : this.scaffoldWithTemplateScaffolder(reference, projectId, classifier);
    }

    private boolean requestNeedsLegacyScaffolder(String classifier) {
        return this.legacyScaffolder.contains(classifier);
    }

    private static String getClassifier(String apiUri) {
        String[] parts = apiUri.split(":");
        return parts.length == 8 ? parts[5] : null;
    }

    private CompletableFuture<ScaffoldResponse> scaffoldWithLegacyScaffolder(ApiReference apiReference, String projectId, String classifier) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> muleConfigUris;
            ScaffoldingConfiguration configuration;
            logger.info("Scaffolding for {} started (using legacy scaffolder)", (Object)projectId);
            ParseResult parseResult = new ParserService().parse(apiReference);
            if (!parseResult.success()) {
                throw new ParsingException(parseResult);
            }
            ScaffolderContext context = ScaffolderContextBuilder.builder().withRuntimeEdition(RuntimeEdition.EE).build();
            MainAppScaffolder mainAppScaffolder = new MainAppScaffolder(context);
            ScaffoldingResult scaffoldResult = mainAppScaffolder.run(configuration = new ScaffoldingConfiguration.Builder().withApi(parseResult.get()).withMuleConfigurations(this.projectHandler.getMuleConfigFiles(projectId)).build());
            if (!scaffoldResult.isSuccess()) {
                throw new ScaffoldingException(scaffoldResult);
            }
            try {
                muleConfigUris = this.projectHandler.persistScaffoldingConfigs(projectId, scaffoldResult.getGeneratedConfigs());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.projectHandler.addRequiredDependencies(projectId, classifier);
            logger.info("Scaffolding for {} finished successfully", (Object)projectId);
            return ResponseHandler.createSuccessResponse(muleConfigUris);
        }).exceptionally(e -> {
            logger.info("Scaffolding for {} failed", (Object)projectId, e);
            return ResponseHandler.createErrorResponse(e);
        });
    }

    private CompletableFuture<ScaffoldResponse> scaffoldWithTemplateScaffolder(ApiReference apiReference, String projectId, String classifier) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> muleConfigFilenames;
            logger.info("Scaffolding for {} started (using template scaffolder)", (Object)projectId);
            AmfApiGraphMapper graphMapper = this.graphMappers.get(classifier);
            APIKitScaffolder scaffolder = new APIKitScaffolder(graphMapper, new DataWeaveTemplateEngine());
            String apiType = this.apiTypes.get(classifier);
            org.mule.apikit.scaffolding.api.ScaffoldingResult scaffoldingResult = scaffolder.scaffold(new ScaffoldingConfigImpl(apiReference.getLocation(), this.projectHandler.getProjectBasePath(projectId).toString(), this.projectHandler.getMuleConfigFilepaths(projectId), this.projectHandler.getMuleResourceFilepaths(projectId), Map.of("src/main/mule/flows.xml", ScaffoldingServiceImpl.getResourceAsStream("scripts/" + apiType + "/flows.dwl"), "src/main/mule/global-configs.xml", ScaffoldingServiceImpl.getResourceAsStream("scripts/" + apiType + "/global-configs.dwl"))));
            if (!scaffoldingResult.success()) {
                throw new ScaffoldingException(scaffoldingResult);
            }
            if (apiType.equals("graphql")) {
                org.mule.apikit.scaffolding.api.ScaffoldingResult munitTestSuiteResult = scaffolder.scaffoldMunitTestSuite(new ScaffoldingConfigImpl(apiReference.getLocation(), this.projectHandler.getProjectBasePath(projectId).toString(), this.projectHandler.getMuleConfigFilepaths(projectId), this.projectHandler.getMuleResourceFilepaths(projectId), Map.of("src/test/munit/apikit-test.xml", ScaffoldingServiceImpl.getResourceAsStream("scripts/" + apiType + "/apikit-test.dwl"))));
                if (!munitTestSuiteResult.success()) {
                    logger.info("MUnit tests scaffolding for {} failed", (Object)projectId);
                } else {
                    try {
                        this.projectHandler.writeFilesToProject(projectId, "/", munitTestSuiteResult.generatedMuleXmls());
                        this.projectHandler.writeFilesToProject(projectId, "/", munitTestSuiteResult.generatedPropertiesFiles());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            try {
                muleConfigFilenames = this.projectHandler.writeFilesToProject(projectId, "/", scaffoldingResult.generatedMuleXmls());
                this.projectHandler.writeFilesToProject(projectId, "/", scaffoldingResult.generatedPropertiesFiles());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (CollectionUtils.isNotEmpty(scaffoldingResult.dependencies())) {
                if (scaffoldingResult.additionalInformation().containsKey("apiFragments")) {
                    String resource = apiReference.getLocation();
                    String[] parts = resource.substring("resource::".length()).split(":");
                    String groupId = parts[0];
                    String artifact = parts[1];
                    String version2 = parts[2];
                    MavenDependencyModel dependency = this.projectHandler.fetchDependency(projectId, classifier, groupId, artifact, version2);
                    this.projectHandler.removeDependency(projectId, classifier, groupId, artifact, version2);
                    MavenDependencyModelImpl mavenDependencyModel = new MavenDependencyModelImpl(dependency);
                    this.projectHandler.addRequiredDependencies(projectId, classifier, scaffoldingResult.dependencies(), mavenDependencyModel);
                } else {
                    this.projectHandler.addRequiredDependencies(projectId, classifier, scaffoldingResult.dependencies());
                }
            } else {
                this.projectHandler.addRequiredDependencies(projectId, classifier);
            }
            logger.info("Scaffolding for {} finished successfully", (Object)projectId);
            return ResponseHandler.createSuccessResponse(muleConfigFilenames, scaffoldingResult.additionalInformation());
        }).exceptionally(e -> {
            logger.info("Scaffolding for {} failed", (Object)projectId, e);
            return ResponseHandler.createErrorResponse(e);
        });
    }

    private static InputStream getResourceAsStream(String resourceName) {
        return APIKitScaffolder.class.getClassLoader().getResourceAsStream(resourceName);
    }
}

