/*
 * Decompiled with CFR 0.152.
 */
package org.mule.dx.contributions.scaffolding.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.apikit.scaffolding.api.ScaffoldingDependency;
import org.mule.dx.contributions.scaffolding.APIKitDependency;
import org.mule.dx.contributions.scaffolding.AsyncKitDependency;
import org.mule.dx.contributions.scaffolding.Dependency;
import org.mule.dx.contributions.scaffolding.GenericDependency;
import org.mule.dx.contributions.scaffolding.GraphQLDependency;
import org.mule.dx.contributions.scaffolding.HTTPDependency;
import org.mule.dx.contributions.scaffolding.MUnitRunnerDependency;
import org.mule.dx.contributions.scaffolding.MUnitToolsDependency;
import org.mule.dx.platform.api.dependency.DependencyModel;
import org.mule.dx.platform.api.dependency.DependencyModelManager;
import org.mule.dx.platform.api.dependency.DependencyModelMutator;
import org.mule.dx.platform.api.graphql.GraphQlClient;
import org.mule.dx.platform.api.maven.MavenDependencyModel;
import org.mule.dx.platform.api.project.Project;
import org.mule.maven.pom.parser.api.model.BundleScope;

public class DependenciesHandler {
    private final Map<String, List<Dependency>> dependencies;
    private final GraphQlClient graphQlClient;

    public DependenciesHandler(GraphQlClient graphQlClient) {
        ImmutableList<HTTPDependency> restDependencies = ImmutableList.of(new APIKitDependency(graphQlClient), new HTTPDependency(graphQlClient));
        ImmutableList<HTTPDependency> asyncDependencies = ImmutableList.of(new AsyncKitDependency(graphQlClient), new HTTPDependency(graphQlClient));
        ImmutableList<MUnitToolsDependency> graphqlDependencies = ImmutableList.of(new GraphQLDependency(graphQlClient), new HTTPDependency(graphQlClient), new MUnitRunnerDependency(graphQlClient), new MUnitToolsDependency(graphQlClient));
        this.dependencies = ImmutableMap.of("raml", restDependencies, "oas", restDependencies, "evented-api", asyncDependencies, "graphql", graphqlDependencies, "light-graphql", graphqlDependencies, "graphql-apollo", graphqlDependencies, "light-graphql-apollo", graphqlDependencies);
        this.graphQlClient = graphQlClient;
    }

    public void addDependencies(Project project, String classifier, List<ScaffoldingDependency> scaffoldingDependencies) throws RuntimeException {
        List<Dependency> moduleDependencies = this.dependencies.get(classifier);
        List connectorDependencies = scaffoldingDependencies.stream().map(scaffoldingDependency -> {
            String[] gavParts = scaffoldingDependency.gavCoordinate().split(":");
            String groupId = gavParts[0];
            String artifactId = gavParts[1];
            String version2 = gavParts[2];
            return new GenericDependency(this.graphQlClient, groupId, artifactId, version2, scaffoldingDependency.classifier());
        }).collect(Collectors.toList());
        ArrayList<Dependency> combinedList = new ArrayList<Dependency>();
        combinedList.addAll(moduleDependencies);
        combinedList.addAll(connectorDependencies);
        this.addDependencies(project, combinedList);
    }

    public void addDependencies(Project project, String classifier, List<ScaffoldingDependency> scaffoldingDependencies, MavenDependencyModel apiDependency) throws RuntimeException {
        List<Dependency> moduleDependencies = this.dependencies.get(classifier);
        List connectorDependencies = scaffoldingDependencies.stream().map(scaffoldingDependency -> {
            String[] gavParts = scaffoldingDependency.gavCoordinate().split(":");
            String groupId = gavParts[0];
            String artifactId = gavParts[1];
            String version2 = gavParts[2];
            return new GenericDependency(this.graphQlClient, groupId, artifactId, version2, scaffoldingDependency.classifier());
        }).collect(Collectors.toList());
        ArrayList<Dependency> combinedList = new ArrayList<Dependency>();
        combinedList.addAll(moduleDependencies);
        combinedList.addAll(connectorDependencies);
        this.addDependencies(project, combinedList, apiDependency);
    }

    public void addDependencies(Project project, String classifier) throws RuntimeException {
        this.addDependencies(project, this.dependencies.get(classifier));
    }

    public void removeDependency(Project project, String classifier, String groupId, String artifactId, String version2) throws RuntimeException {
        MavenDependencyModel dependency;
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to remove module dependencies"));
        DependencyModelMutator mutator = (DependencyModelMutator)modelManager.mutator().get();
        boolean removed = mutator.removeDependency((DependencyModel)(dependency = DependenciesHandler.findDependency((DependencyModelManager<MavenDependencyModel>)modelManager, groupId, artifactId, version2)));
        if (!removed) {
            throw new RuntimeException("Failed to remove module dependency");
        }
        mutator.persist();
    }

    public MavenDependencyModel fetchDependency(Project project, String classifier, String groupId, String artifactId, String version2) throws RuntimeException {
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to find module dependencies"));
        DependencyModelMutator mutator = (DependencyModelMutator)modelManager.mutator().get();
        MavenDependencyModel dependency = DependenciesHandler.findDependency((DependencyModelManager<MavenDependencyModel>)modelManager, groupId, artifactId, version2);
        return dependency;
    }

    public static MavenDependencyModel findDependency(DependencyModelManager<MavenDependencyModel> modelManager, String groupId, String artifactId, String version2) {
        MavenDependencyModel dependencyModel = null;
        try {
            CompletableFuture mavenDependencyModelCompletableFuture = modelManager.loadModel();
            List dependencies = ((MavenDependencyModel)mavenDependencyModelCompletableFuture.get()).getDependencies().stream().collect(Collectors.toList());
            List dependencyModels = dependencies.stream().filter(m4 -> {
                MavenDependencyModel model = (MavenDependencyModel)m4;
                return model.getGroupId().equals(groupId) && model.getArtifactId().equals(artifactId) && model.getVersion().equals(version2);
            }).collect(Collectors.toList());
            dependencyModel = (MavenDependencyModel)dependencies.get(0);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("", e);
        }
        return dependencyModel;
    }

    private void addDependencies(Project project, List<Dependency> dependencies) throws RuntimeException {
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to add module dependencies"));
        DependencyModelMutator mutator = (DependencyModelMutator)modelManager.mutator().get();
        dependencies.forEach(moduleDependency -> {
            boolean success = mutator.addDependency((DependencyModel)DependenciesHandler.toMavenDependencyModel(moduleDependency));
            if (!success) {
                throw new RuntimeException("Failed to add module dependencies");
            }
        });
        mutator.persist();
    }

    private void addDependencies(Project project, List<Dependency> dependencies, MavenDependencyModel apiDependency) throws RuntimeException {
        DependencyModelManager modelManager = (DependencyModelManager)project.getComponent(DependencyModelManager.class).orElseThrow(() -> new RuntimeException("Failed to add module dependencies"));
        DependencyModelMutator mutator = (DependencyModelMutator)modelManager.mutator().get();
        mutator.addDependency((DependencyModel)apiDependency);
        dependencies.forEach(moduleDependency -> {
            boolean success = mutator.addDependency((DependencyModel)DependenciesHandler.toMavenDependencyModel(moduleDependency));
            if (!success) {
                throw new RuntimeException("Failed to add module dependencies");
            }
        });
        mutator.persist();
    }

    private static MavenDependencyModel toMavenDependencyModel(final Dependency moduleDependency) {
        return new MavenDependencyModel(){

            public String getGroupId() {
                return moduleDependency.groupId();
            }

            public String getArtifactId() {
                return moduleDependency.artifactId();
            }

            public String getBaseVersion() {
                return null;
            }

            public String getType() {
                return null;
            }

            public Optional<String> getClassifier() {
                return Optional.of(moduleDependency.classifier());
            }

            public BundleScope getScope() {
                return null;
            }

            public org.apache.maven.model.Dependency toMavenNativeModel() {
                org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId(moduleDependency.groupId());
                dependency.setArtifactId(moduleDependency.artifactId());
                dependency.setVersion(moduleDependency.version());
                dependency.setClassifier(moduleDependency.classifier());
                dependency.setScope(moduleDependency.scope());
                return dependency;
            }

            public String getId() {
                return null;
            }

            public Collection<DependencyModel> getDependencies() {
                return null;
            }

            public String getSystemID() {
                return null;
            }

            public String getVersion() {
                return moduleDependency.version();
            }

            public URI getLocation() {
                return null;
            }
        };
    }
}

