/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;

public class IntersectionTypeBuilder
extends AbstractBuilder<IntersectionType>
implements TypeBuilder<IntersectionType>,
WithAnnotation<IntersectionTypeBuilder> {
    private List<TypeBuilder<?>> types = new LinkedList();

    protected IntersectionTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public BaseTypeBuilder of() {
        BaseTypeBuilder builder = new BaseTypeBuilder(this.format);
        this.types.add(builder);
        return builder;
    }

    public IntersectionTypeBuilder of(TypeBuilder<?> of) {
        this.types.add(of);
        return this;
    }

    public IntersectionTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    @Override
    public IntersectionTypeBuilder with(TypeAnnotation extension2) {
        this.addExtension(extension2);
        return this;
    }

    @Override
    public IntersectionType build() {
        if (this.types.isEmpty()) {
            throw new RuntimeException("Tuple needs at least one type");
        }
        List<MetadataType> types = this.types.stream().map(builder -> builder.build()).collect(Collectors.toList());
        return new DefaultIntersectionType(types, this.format, this.annotations);
    }
}

