/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultUnionType;

public class UnionTypeBuilder
extends AbstractBuilder<UnionType>
implements TypeBuilder<UnionType>,
WithAnnotation<UnionTypeBuilder> {
    private final List<Supplier<MetadataType>> types = new LinkedList<Supplier<MetadataType>>();

    protected UnionTypeBuilder(MetadataFormat format) {
        super(format);
    }

    public BaseTypeBuilder of() {
        BaseTypeBuilder builder = new BaseTypeBuilder(this.format);
        this.of(builder);
        return builder;
    }

    public UnionTypeBuilder of(TypeBuilder<?> builder) {
        this.types.add(builder::build);
        return this;
    }

    public UnionTypeBuilder of(MetadataType type) {
        this.types.add(() -> type);
        return this;
    }

    public UnionTypeBuilder id(String typeIdentifier) {
        return this.with(new TypeIdAnnotation(typeIdentifier));
    }

    @Override
    public UnionTypeBuilder with(TypeAnnotation extension2) {
        this.addExtension(extension2);
        return this;
    }

    @Override
    public UnionType build() {
        if (this.types.isEmpty()) {
            throw new RuntimeException("Tuple needs at least one type");
        }
        List<MetadataType> types = this.types.stream().map(Supplier::get).collect(Collectors.toList());
        return new DefaultUnionType(types, this.format, this.annotations);
    }
}

