/*
 * Decompiled with CFR 0.152.
 */
package org.mule.parser.service.strategy;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.apikit.ApiParser;
import org.mule.apikit.implv1.ParserWrapperV1;
import org.mule.apikit.implv2.ParserWrapperV2;
import org.mule.apikit.loader.ResourceLoader;
import org.mule.apikit.model.ApiVendor;
import org.mule.apikit.model.api.ApiReference;
import org.mule.apikit.validation.ApiValidationReport;
import org.mule.parser.service.references.ReferencesResolver;
import org.mule.parser.service.result.DefaultParseResult;
import org.mule.parser.service.result.ExceptionParseResult;
import org.mule.parser.service.result.ParseResult;
import org.mule.parser.service.strategy.ParsingStrategy;
import org.mule.parser.service.strategy.ValidationReportHelper;

public class RamlParsingStrategy
implements ParsingStrategy {
    private ReferencesResolver referencesResolver;

    public RamlParsingStrategy() {
        this.referencesResolver = new ReferencesResolver();
    }

    public RamlParsingStrategy(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
    }

    @Override
    public ParseResult parse(ApiReference ref) {
        try {
            ApiParser parser2 = this.create(ref);
            ApiValidationReport report = parser2.validate();
            return new DefaultParseResult(report.conforms() ? parser2.parse() : null, ValidationReportHelper.errors(report), ValidationReportHelper.warnings(report));
        }
        catch (Exception e) {
            return new ExceptionParseResult(e);
        }
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.referencesResolver.setExecutor(executor);
    }

    public ApiParser create(ApiReference ref) {
        String path = ref.getLocation();
        ResourceLoader apiLoader = ref.getResourceLoader().orElse(null);
        List<String> references = this.referencesResolver.getReferences(ref);
        if (ApiVendor.RAML_08.equals((Object)ref.getVendor())) {
            return this.createParserV1(path, apiLoader, references);
        }
        return this.createRamlV2(path, apiLoader, references);
    }

    private ParserWrapperV1 createParserV1(String path, ResourceLoader loader, List<String> refs) {
        return loader != null ? new ParserWrapperV1(path, Collections.singletonList(loader::getResourceAsStream), refs) : new ParserWrapperV1(path, refs);
    }

    private ParserWrapperV2 createRamlV2(String path, ResourceLoader loader, List<String> refs) {
        return loader != null ? new ParserWrapperV2(path, Collections.singletonList(loader::getResourceAsStream), refs) : new ParserWrapperV2(path, refs);
    }
}

