/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Product {
    MULE(Collections.emptyList()),
    MULE_EE(Arrays.asList(MULE));

    private List<Product> supportedProducts;

    private Product(List<Product> supportedProducts) {
        this.supportedProducts = supportedProducts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean supports(Product product2) {
        if (product2.equals((Object)this)) return true;
        if (!this.supportedProducts.stream().filter(product2::equals).findAny().isPresent()) return false;
        return true;
    }

    public static Product getProductByName(String coreLibraryName) {
        if (coreLibraryName == null) {
            return MULE_EE;
        }
        if (coreLibraryName.equals("Mule Core")) {
            return MULE;
        }
        if (coreLibraryName.equals("Mule EE Core")) {
            return MULE_EE;
        }
        throw new IllegalArgumentException(String.format("Core library name %s could not be recognized", coreLibraryName));
    }
}

