/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.DefaultExceptionReader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleExceptionReader;
import org.mule.runtime.api.exception.NamingExceptionReader;
import org.mule.runtime.api.legacy.exception.ExceptionReader;

public class ExceptionHelper {
    private static final String MULE_PACKAGE_REGEXP = "(?:org|com)\\.mule(?:soft)?\\.(?!mvel2)(?!el).*";
    private static final int ALREADY_FILTERED_INDICATOR = -3;
    public static final String[] DEFAULT_STACKTRACE_FILTER = new String[]{"org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor", "org.mule.runtime.core.privileged.processor.chain", "org.mule.runtime.core.internal.processor.chain", "reactor.core"};
    private static final int EXCEPTION_THRESHOLD = 3;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static List<ExceptionReader> globalExceptionReaders = new ArrayList<ExceptionReader>();
    private static List<ExceptionReader> exceptionReaders = new ArrayList<ExceptionReader>();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();
    public static String[] stackTraceFilter = DEFAULT_STACKTRACE_FILTER;

    protected ExceptionHelper() {
    }

    public static <T extends Throwable> T unwrap(T t2) {
        if (t2 instanceof InvocationTargetException) {
            return (T)((InvocationTargetException)t2).getTargetException();
        }
        return t2;
    }

    public static ExceptionReader getExceptionReader(Throwable t2) {
        for (ExceptionReader exceptionReader : globalExceptionReaders) {
            if (!exceptionReader.getExceptionType().isInstance(t2)) continue;
            return exceptionReader;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (ExceptionReader exceptionReader : exceptionReaders) {
            ClassLoader currentCl;
            for (currentCl = tccl; currentCl != null && currentCl != ExceptionHelper.class.getClassLoader() && currentCl != exceptionReader.getClass().getClassLoader(); currentCl = currentCl.getParent()) {
            }
            if (currentCl != exceptionReader.getClass().getClassLoader() || !exceptionReader.getExceptionType().isInstance(t2)) continue;
            return exceptionReader;
        }
        return defaultExceptionReader;
    }

    public static MuleException getRootMuleException(Throwable t2) {
        Throwable cause = t2;
        MuleException exception = null;
        HashMap<String, Object> muleExceptionInfo = new HashMap<String, Object>();
        while (cause != null) {
            if (cause instanceof MuleException) {
                exception = (MuleException)cause;
                muleExceptionInfo.putAll(exception.getInfo());
            }
            Throwable tempCause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
            cause = verbose ? tempCause : ExceptionHelper.sanitize(tempCause);
            if (t2 != cause) continue;
            break;
        }
        if (exception != null) {
            exception.getInfo().putAll(muleExceptionInfo);
        }
        return exception;
    }

    public static Throwable getNonMuleException(Throwable t2) {
        if (!(t2 instanceof MuleException)) {
            return t2;
        }
        Throwable cause = t2;
        while (cause != null && t2 != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause)) && cause instanceof MuleException) {
        }
        return cause instanceof MuleException ? null : cause;
    }

    public static Map<String, Object> getExceptionInfo(Throwable t2) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        Throwable cause = t2;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            if (t2 != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return info;
    }

    public static Throwable getRootException(Throwable t2) {
        Throwable cause = t2;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            if (t2 != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
        }
        return verbose ? root : ExceptionHelper.sanitize(root);
    }

    public static String getExceptionStack(Throwable t2) {
        Throwable root = ExceptionHelper.getRootException(t2);
        MuleException rootMule = ExceptionHelper.getRootMuleException(t2);
        StringBuilder buf = new StringBuilder();
        ExceptionReader rootMuleReader = ExceptionHelper.getExceptionReader(rootMule);
        buf.append(rootMuleReader.getMessage(rootMule)).append(" (").append(rootMule.getClass().getName()).append(")").append(System.lineSeparator());
        if (verbose) {
            int processedElements = 0;
            int processedMuleElements = 1;
            for (StackTraceElement stackTraceElement : root.getStackTrace()) {
                if (processedMuleElements > 3) break;
                ++processedElements;
                if (stackTraceElement.getClassName().matches(MULE_PACKAGE_REGEXP)) {
                    ++processedMuleElements;
                }
                buf.append("  ").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")").append(System.lineSeparator());
            }
            if (root.getStackTrace().length - processedElements > 0) {
                buf.append("  (").append(root.getStackTrace().length - processedElements).append(" more...)").append(System.lineSeparator());
            }
        }
        return buf.toString();
    }

    private static void initialise() {
        if (initialised) {
            return;
        }
        String stackTraceFilterString = System.getProperty("mule.stacktrace.filter");
        if (stackTraceFilterString != null) {
            stackTraceFilter = stackTraceFilterString.split(",");
        }
        ExceptionHelper.registerGlobalExceptionReader(new MuleExceptionReader());
        ExceptionHelper.registerGlobalExceptionReader(new NamingExceptionReader());
        initialised = true;
    }

    public static Throwable sanitize(Throwable t2) {
        if (t2 == null) {
            return null;
        }
        StackTraceElement[] trace = t2.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        String currentlyMatchedPrefix = null;
        int currentlyMatchedPrefixCount = 0;
        for (StackTraceElement stackTraceElement : trace) {
            Optional<String> matchedPrefix = ExceptionHelper.matchedMuleInternalClassPrefix(stackTraceElement);
            if (!matchedPrefix.isPresent()) {
                if (currentlyMatchedPrefix != null) {
                    newTrace.add(ExceptionHelper.createFilteredStackEntry(currentlyMatchedPrefix, currentlyMatchedPrefixCount));
                    currentlyMatchedPrefix = null;
                    currentlyMatchedPrefixCount = 0;
                }
                newTrace.add(stackTraceElement);
                continue;
            }
            if (currentlyMatchedPrefix != null) {
                if (currentlyMatchedPrefix.equals(matchedPrefix.get())) {
                    ++currentlyMatchedPrefixCount;
                    continue;
                }
                newTrace.add(ExceptionHelper.createFilteredStackEntry(currentlyMatchedPrefix, currentlyMatchedPrefixCount));
            }
            currentlyMatchedPrefix = matchedPrefix.get();
            currentlyMatchedPrefixCount = 1;
        }
        StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
        newTrace.toArray(clean);
        t2.setStackTrace(clean);
        for (Throwable cause = t2.getCause(); cause != null; cause = cause.getCause()) {
            ExceptionHelper.sanitize(cause);
        }
        return t2;
    }

    private static StackTraceElement createFilteredStackEntry(String currentlyMatchedPrefix, int currentlyMatchedPrefixCount) {
        return new StackTraceElement(currentlyMatchedPrefix, String.format("* (%d elements filtered from stack; set debug level logging or '-Dmule.verbose.exceptions=true' for everything)", currentlyMatchedPrefixCount), null, -3);
    }

    public static Throwable summarise(Throwable t2, int depth) {
        t2 = ExceptionHelper.sanitize(t2);
        StackTraceElement[] trace = t2.getStackTrace();
        int newStackDepth = Math.min(trace.length, depth);
        StackTraceElement[] newTrace = new StackTraceElement[newStackDepth];
        System.arraycopy(trace, 0, newTrace, 0, newStackDepth);
        t2.setStackTrace(newTrace);
        return t2;
    }

    private static Optional<String> matchedMuleInternalClassPrefix(StackTraceElement stackTraceElement) {
        if (stackTraceElement.getLineNumber() == -3) {
            return Optional.empty();
        }
        for (String mulePackage : stackTraceFilter) {
            if (!stackTraceElement.getClassName().startsWith(mulePackage)) continue;
            return Optional.of(mulePackage);
        }
        return Optional.empty();
    }

    public static List<Throwable> getExceptionsAsList(Throwable t2) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable cause = t2;
        while (cause != null) {
            exceptions.add(0, cause);
            if (t2 != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exceptions;
    }

    public static void registerGlobalExceptionReader(ExceptionReader reader) {
        if (reader.getClass().getClassLoader() != ExceptionHelper.class.getClassLoader()) {
            throw new IllegalArgumentException("Only the Runtime itself may register global readers.");
        }
        globalExceptionReaders.add(reader);
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        for (ExceptionReader exceptionReader : globalExceptionReaders) {
            if (!exceptionReader.getExceptionType().equals(reader.getExceptionType())) continue;
            throw new IllegalArgumentException(String.format("There's a globalExceptionReader already registerd for '%s': %s", reader.getExceptionType(), reader.toString()));
        }
        exceptionReaders.add(reader);
    }

    public static boolean unregisterExceptionReader(ExceptionReader reader) {
        return exceptionReaders.remove(reader);
    }

    static {
        ExceptionHelper.initialise();
    }
}

