/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithParametersDeclaration;
import org.mule.runtime.api.util.Preconditions;

public abstract class ParameterizedDeclaration<T extends ParameterizedDeclaration>
extends NamedDeclaration<T>
implements WithParametersDeclaration {
    private final Map<String, ParameterGroupDeclaration> parameterGroups = new LinkedHashMap<String, ParameterGroupDeclaration>();

    ParameterizedDeclaration(String name) {
        super(name);
    }

    @Override
    public List<ParameterGroupDeclaration> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroupDeclaration>(this.parameterGroups.values()));
    }

    @Override
    public ParameterGroupDeclaration getParameterGroup(String groupName) {
        Preconditions.checkArgument(!StringUtils.isBlank(groupName), "groupName cannot be blank");
        return this.parameterGroups.computeIfAbsent(groupName, ParameterGroupDeclaration::new);
    }

    @Override
    public List<ParameterDeclaration> getAllParameters() {
        return this.parameterGroups.values().stream().flatMap(g2 -> g2.getParameters().stream()).collect(Collectors.toList());
    }
}

