/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;

@NoImplement
public interface DataType
extends Serializable {
    public static final DataType TEXT_STRING = DataType.builder().type(String.class).mediaType(MediaType.TEXT).build();
    public static final DataType XML_STRING = DataType.builder().type(String.class).mediaType(MediaType.XML).build();
    public static final DataType JSON_STRING = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_JSON).build();
    public static final DataType HTML_STRING = DataType.builder().type(String.class).mediaType(MediaType.HTML).build();
    public static final DataType ATOM_STRING = DataType.builder().type(String.class).mediaType(MediaType.ATOM).build();
    public static final DataType RSS_STRING = DataType.builder().type(String.class).mediaType(MediaType.RSS).build();
    public static final DataType STRING = DataType.fromType(String.class);
    public static final DataType NUMBER = DataType.fromType(Number.class);
    public static final DataType BOOLEAN = DataType.fromType(Boolean.class);
    public static final DataType OBJECT = DataType.fromType(Object.class);
    public static final DataType BYTE_ARRAY = DataType.fromType(byte[].class);
    public static final DataType INPUT_STREAM = DataType.fromType(InputStream.class);
    public static final DataType ITERATOR = DataType.fromType(Iterator.class);
    public static final DataType CURSOR_STREAM_PROVIDER = DataType.fromType(CursorStreamProvider.class);
    public static final DataType CURSOR_ITERATOR_PROVIDER = DataType.fromType(CursorIteratorProvider.class);
    public static final DataType TYPED_VALUE = DataType.fromType(TypedValue.class);
    public static final DataType MULE_MESSAGE = DataType.builder().type(Message.class).mediaType(MediaType.ANY).build();
    public static final CollectionDataType MULE_MESSAGE_COLLECTION = (CollectionDataType)AbstractDataTypeBuilderFactory.getDefaultFactory().create().collectionType(Collection.class).itemType(Message.class).mediaType(MediaType.ANY).build();
    public static final CollectionDataType MULE_MESSAGE_LIST = (CollectionDataType)AbstractDataTypeBuilderFactory.getDefaultFactory().create().collectionType(List.class).itemType(Message.class).mediaType(MediaType.ANY).build();
    public static final MapDataType MULE_MESSAGE_MAP = (MapDataType)AbstractDataTypeBuilderFactory.getDefaultFactory().create().mapType(Map.class).keyType(String.class).valueType(Message.class).valueMediaType(MediaType.ANY).build();

    public static DataTypeBuilder builder() {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create();
    }

    public static DataTypeBuilder builder(DataType dataType) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create(dataType);
    }

    public static DataType fromType(Class<?> type) {
        return DataType.builder().type(type).build();
    }

    public static DataType fromObject(Object value) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create().fromObject(value).build();
    }

    public static DataType fromFunction(ExpressionFunction function2) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create().fromFunction(function2).build();
    }

    public static boolean areCompatible(DataType superType, DataType subType) {
        return superType.isCompatibleWith(subType);
    }

    public Class<?> getType();

    public MediaType getMediaType();

    public boolean isCompatibleWith(DataType var1);

    public boolean isStreamType();
}

