/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.util.LazyValue;

@Experimental
public class SerializableLazyValue<T extends Serializable>
extends LazyValue<T>
implements Serializable {
    private static final long serialVersionUID = 8803029647811486550L;

    public SerializableLazyValue(Supplier<T> supplier) {
        super(supplier);
    }

    public SerializableLazyValue(T value) {
        super(value);
    }

    @Override
    public T get() {
        return (T)((Serializable)super.get());
    }

    @Override
    public <R> R flatMap(Function<T, R> function2) {
        return super.flatMap(function2);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.initialized = in.readBoolean();
        this.value = (Serializable)in.readObject();
        this.valueSupplier = () -> (Serializable)this.value;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this.initialized) {
            this.get();
        }
        out.writeBoolean(this.initialized);
        out.writeObject(this.value);
    }
}

