/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.api;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.EnrichableElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.ReferableElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.internal.utils.Preconditions;

public final class TopLevelParameterDeclaration
extends EnrichableElementDeclaration
implements ReferableElementDeclaration,
GlobalElementDeclaration {
    private String elementName;
    private ParameterObjectValue value;

    public TopLevelParameterDeclaration() {
    }

    public TopLevelParameterDeclaration(String extension2, String name) {
        this.setDeclaringExtension(extension2);
        this.setName(name);
    }

    public void setValue(ParameterObjectValue value) {
        Preconditions.checkArgument(value != null, "The value of the parameter cannot be null");
        this.value = value;
    }

    public ParameterObjectValue getValue() {
        return this.value;
    }

    @Override
    public String getRefName() {
        return this.elementName;
    }

    @Override
    public void setRefName(String referableName) {
        Preconditions.checkArgument(referableName != null && !referableName.trim().isEmpty(), "Element referableName cannot be blank");
        this.elementName = referableName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopLevelParameterDeclaration) || !super.equals(o)) {
            return false;
        }
        TopLevelParameterDeclaration that = (TopLevelParameterDeclaration)o;
        return this.declaringExtension.equals(that.declaringExtension) && this.elementName.equals(that.elementName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.declaringExtension.hashCode();
        result = 31 * result + this.elementName.hashCode();
        return result;
    }

    @Override
    public void accept(GlobalElementDeclarationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

