/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tools.apikit.input.parsers.APIKitFlowsParser;
import org.mule.tools.apikit.input.parsers.APIKitRoutersParser;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MuleConfig;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;

public class MuleConfigParser {
    private Set<ResourceActionMimeTypeTriplet> entries = new HashSet<ResourceActionMimeTypeTriplet>();
    private Map<String, ApikitMainFlowContainer> includedApis = new HashMap<String, ApikitMainFlowContainer>();
    private List<APIKitConfig> apikitConfigs = new LinkedList<APIKitConfig>();
    private final APIFactory apiFactory;

    public MuleConfigParser(APIFactory apiFactory, String apiLocation, List<MuleConfig> muleConfigs) {
        this.apiFactory = apiFactory;
        for (MuleConfig config : muleConfigs) {
            this.parseConfig(config);
        }
        for (MuleConfig config : muleConfigs) {
            this.parseApis(config, apiLocation);
        }
        this.parseFlows(muleConfigs);
    }

    void parseConfig(MuleConfig config) {
        this.apikitConfigs.addAll(config.getApikitConfigs());
        config.getHttpListenerConfigs().forEach(httpConfig -> {
            if (!this.apiFactory.getHttpListenerConfigs().contains(httpConfig)) {
                this.apiFactory.getHttpListenerConfigs().add((HttpListenerConfig)httpConfig);
            }
        });
    }

    void parseApis(MuleConfig muleConfig, String apiFilePath) {
        this.includedApis.putAll((Map<String, ApikitMainFlowContainer>)new APIKitRoutersParser(this.apikitConfigs, this.apiFactory, apiFilePath, muleConfig).parse(muleConfig.getContentAsDocument()));
    }

    void parseFlows(List<MuleConfig> configs) {
        for (MuleConfig config : configs) {
            this.entries.addAll((Collection<ResourceActionMimeTypeTriplet>)new APIKitFlowsParser(this.includedApis).parse(config.getContentAsDocument()));
        }
    }

    List<APIKitConfig> getApikitConfigs() {
        return this.apikitConfigs;
    }

    public Set<ResourceActionMimeTypeTriplet> getEntries() {
        return this.entries;
    }

    public Set<ApikitMainFlowContainer> getIncludedApis() {
        return new HashSet<ApikitMainFlowContainer>(this.includedApis.values());
    }
}

