/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIKitConfig;

public class APIKitConfigParser
implements MuleConfigFileParser<List<APIKitConfig>> {
    private static final XPathExpression<Element> APIKIT_CONFIG_EXPRESSION = APIKitConfigParser.getCompiledExpression();

    @Override
    public List<APIKitConfig> parse(Document document) {
        List<Element> apikitConfigElements = APIKIT_CONFIG_EXPRESSION.evaluate(document);
        return apikitConfigElements.stream().map(apikitConfigElement -> {
            Attribute name = apikitConfigElement.getAttribute("name");
            Attribute api = apikitConfigElement.getAttribute("api");
            Attribute raml = apikitConfigElement.getAttribute("raml");
            Attribute extensionEnabled = apikitConfigElement.getAttribute("extensionEnabled");
            Attribute outboundHeadersMapName = apikitConfigElement.getAttribute("outboundHeadersMapName");
            Attribute httpStatusVarName = apikitConfigElement.getAttribute("httpStatusVarName");
            APIKitConfig apiKitConfig = new APIKitConfig();
            if (api != null) {
                apiKitConfig.setApi(api.getValue());
            } else if (raml != null) {
                apiKitConfig.setRaml(raml.getValue());
            } else {
                throw new IllegalArgumentException("api attribute is required on apikit configuration");
            }
            apiKitConfig.setName(name != null ? name.getValue() : "noNameConfig");
            if (outboundHeadersMapName != null) {
                apiKitConfig.setOutboundHeadersMapName(outboundHeadersMapName.getValue());
            }
            if (extensionEnabled != null) {
                apiKitConfig.setExtensionEnabled(Boolean.valueOf(extensionEnabled.getValue()));
            }
            if (httpStatusVarName != null) {
                apiKitConfig.setHttpStatusVarName(httpStatusVarName.getValue());
            }
            APIKitConfig.ADDITIONAL_ATTRIBUTES.stream().map(apikitConfigElement::getAttribute).filter(Objects::nonNull).forEach(apiKitConfig::addAdditionalAttribute);
            return apiKitConfig;
        }).collect(Collectors.toList());
    }

    private static XPathExpression<Element> getCompiledExpression() {
        return XPathFactory.instance().compile("//*/*[local-name()='config']", Filters.element(APIKitTools.API_KIT_NAMESPACE.getNamespace()));
    }
}

