/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import com.google.common.collect.Sets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.common.ApiSyncUtils;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.misc.APIKitTools;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MuleConfig;

public class APIKitRoutersParser
implements MuleConfigFileParser {
    private static final XPathExpression<Element> COMPILED_ROUTER_EXPRESSION = APIKitRoutersParser.getCompiledExpression();
    private final List<APIKitConfig> apikitConfigs;
    private final List<HttpListenerConfig> httpListenerConfigs;
    private final String apiFilePath;
    private final APIFactory apiFactory;
    private MuleConfig muleConfig;

    private static XPathExpression<Element> getCompiledExpression() {
        return XPathFactory.instance().compile("//*/*[local-name()='router']", Filters.element(APIKitTools.API_KIT_NAMESPACE.getNamespace()));
    }

    public APIKitRoutersParser(List<APIKitConfig> apikitConfigs, APIFactory apiFactory, String apiFilePath, MuleConfig config) {
        this.apikitConfigs = apikitConfigs;
        this.httpListenerConfigs = apiFactory.getHttpListenerConfigs();
        this.apiFilePath = apiFilePath;
        this.apiFactory = apiFactory;
        this.muleConfig = config;
    }

    public Map<String, ApikitMainFlowContainer> parse(Document document) {
        Set<String> allApisPathsInApplication = this.getAllApisPathsInApplication();
        HashMap<String, ApikitMainFlowContainer> includedApis = new HashMap<String, ApikitMainFlowContainer>();
        List<Element> elements = COMPILED_ROUTER_EXPRESSION.evaluate(document);
        for (Element element : elements) {
            APIKitConfig config = this.getApikitConfig(element);
            String currentApiPath = FilenameUtils.separatorsToSystem(config.getApi() == null ? Paths.get(config.getRaml(), new String[0]).toString() : config.getApi());
            for (String apiPath : allApisPathsInApplication) {
                String configId;
                if (!this.compareApisLocation(currentApiPath, apiPath)) continue;
                List<Element> flowElements = this.getParentFlowElements(element);
                Element source = this.findListenerOrInboundEndpoint(flowElements);
                String string = configId = config.getName() != null ? config.getName() : "noNameConfig";
                if ("listener".equals(source.getName())) {
                    includedApis.put(configId, this.handleListenerSource(source, apiPath, config));
                    continue;
                }
                if ("inbound-endpoint".equals(source.getName())) {
                    includedApis.put(configId, this.handleInboundEndpointSource(source, apiPath, config));
                    continue;
                }
                throw new IllegalStateException("The first element of the main flow must be an inbound-endpoint or listener");
            }
        }
        return includedApis;
    }

    private List<Element> getParentFlowElements(Element element) {
        if (element == null) {
            throw new IllegalStateException("Router should be contained in a flow");
        }
        if (element.getName().equals("flow")) {
            return element.getChildren();
        }
        return this.getParentFlowElements(element.getParentElement());
    }

    private boolean compareApisLocation(String configRaml, String currentRootRaml) {
        if (ApiSyncUtils.isSyncProtocol(configRaml) && ApiSyncUtils.isSyncProtocol(currentRootRaml)) {
            return ApiSyncUtils.compareResourcesLocation(configRaml, currentRootRaml, false);
        }
        return currentRootRaml.endsWith(configRaml);
    }

    private APIKitConfig getApikitConfig(Element element) throws IllegalStateException {
        Attribute configRef = element.getAttribute("config-ref");
        String configId = configRef != null ? configRef.getValue() : "noNameConfig";
        return this.apikitConfigs.stream().filter(c -> c.getName().equals(configId)).findFirst().orElseThrow(() -> new IllegalStateException("An Apikit configuration is mandatory."));
    }

    private ApikitMainFlowContainer handleListenerSource(Element source, String apiFilePath, APIKitConfig config) {
        HttpListenerConfig httpListenerConfig = this.getHTTPListenerConfig(source);
        String path = this.getPathFromInbound(source);
        return this.apiFactory.createAPIBinding(apiFilePath, null, path, config, httpListenerConfig, this.muleConfig);
    }

    private ApikitMainFlowContainer handleInboundEndpointSource(Element source, String apiFilePath, APIKitConfig config) {
        String baseUri = null;
        String path = source.getAttributeValue("path");
        if (path == null) {
            baseUri = source.getAttributeValue("address");
            if (baseUri == null) {
                throw new IllegalStateException("Neither 'path' nor 'address' attribute was used. Cannot retrieve base URI.");
            }
            path = APIKitTools.getPathFromUri(baseUri, false);
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.apiFactory.createAPIBinding(apiFilePath, baseUri, path, config, null, this.muleConfig);
    }

    private Element findListenerOrInboundEndpoint(List<Element> elements) {
        for (Element element : elements) {
            if (!"listener".equals(element.getName()) && !"inbound-endpoint".equals(element.getName())) continue;
            return element;
        }
        throw new IllegalStateException("The main flow must have an inbound-endpoint or listener");
    }

    private HttpListenerConfig getHTTPListenerConfig(Element inbound) {
        Attribute httpListenerConfigRef = inbound.getAttribute("config-ref");
        String httpListenerConfigId = httpListenerConfigRef != null ? httpListenerConfigRef.getValue() : "httpListenerConfig";
        HttpListenerConfig httpListenerConfig = this.httpListenerConfigs.stream().filter(config -> config.getName().equals(httpListenerConfigId)).findFirst().orElse(null);
        if (httpListenerConfig == null) {
            throw new IllegalStateException("An HTTP Listener configuration is mandatory.");
        }
        return httpListenerConfig;
    }

    private String getPathFromInbound(Element inbound) {
        String address = inbound.getAttributeValue("address");
        if (address != null) {
            return APIKitTools.getPathFromUri(address, false);
        }
        String path = inbound.getAttributeValue("path");
        if (path == null) {
            path = "";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private Set<String> getAllApisPathsInApplication() {
        HashSet<String> paths = Sets.newHashSet(this.apiFilePath);
        this.apikitConfigs.forEach(config -> {
            String apiPath = FilenameUtils.separatorsToSystem(config.getApi() != null ? config.getApi() : Paths.get(config.getRaml(), new String[0]).toString());
            if (paths.stream().noneMatch(path -> this.compareApisLocation(apiPath, (String)path))) {
                paths.add(apiPath);
            }
        });
        return paths;
    }
}

