/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.model;

import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.MuleConfig;

public class ApikitMainFlowContainer {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 8081;
    public static final String DEFAULT_BASE_URI = "http://0.0.0.0:8081/api";
    public static final String DEFAULT_BASE_PATH = "/";
    public static final String DEFAULT_PROTOCOL = "HTTP";
    public static final String DEFAULT_CONSOLE_PATH = "/console/*";
    private APIKitConfig config;
    private HttpListenerConfig httpListenerConfig;
    private String path;
    private String baseUri;
    private String apiFilePath;
    private String id;
    private MuleConfig muleConfig;

    public ApikitMainFlowContainer(String id, String apiFilePath, String baseUri, String path) {
        this.path = path;
        this.apiFilePath = apiFilePath;
        this.baseUri = baseUri;
        this.id = id;
    }

    public ApikitMainFlowContainer(String id, String apiFileName, String baseUri, String path, APIKitConfig config, MuleConfig muleConfig) {
        this(id, apiFileName, baseUri, path);
        this.config = config;
        this.muleConfig = muleConfig;
    }

    public String getApiFilePath() {
        return this.apiFilePath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpListenerConfig getHttpListenerConfig() {
        return this.httpListenerConfig;
    }

    public APIKitConfig getConfig() {
        return this.config;
    }

    public void setConfig(APIKitConfig config) {
        this.config = config;
    }

    public void setHttpListenerConfig(HttpListenerConfig httpListenerConfig) {
        this.httpListenerConfig = httpListenerConfig;
    }

    public void setDefaultAPIKitConfig() {
        this.config = new APIKitConfig();
        this.config.setApi(this.apiFilePath);
        this.config.setName(this.id + "-" + "config");
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public MuleConfig getMuleConfig() {
        return this.muleConfig;
    }

    public void setMuleConfig(MuleConfig muleConfig) {
        this.muleConfig = muleConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApikitMainFlowContainer api = (ApikitMainFlowContainer)o;
        return this.apiFilePath.equals(api.apiFilePath) && this.id.equals(api.id);
    }

    public int hashCode() {
        return this.apiFilePath.hashCode();
    }

    public void setApiFilePath(String apiFilePath) {
        this.apiFilePath = apiFilePath;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

