/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.apikit.model.Action;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.tools.apikit.misc.FlowNameUtils;
import org.mule.tools.apikit.model.ApikitMainFlowContainer;

public class GenerationModel
implements Comparable<GenerationModel> {
    private static final String OAS_DEFAULT_STATUS_CODE = "default";
    private final String verb;
    private final Action action;
    private final Resource resource;
    private final String mimeType;
    private final String version;
    private final List<String> splitPath;
    private final ApikitMainFlowContainer api;

    public GenerationModel(ApikitMainFlowContainer api, String version2, Resource resource, Action action) {
        this(api, version2, resource, action, null);
    }

    public GenerationModel(ApikitMainFlowContainer api, String version2, Resource resource, Action action, String mimeType) {
        this.api = api;
        Validate.notNull(api);
        Validate.notNull(action);
        Validate.notNull((Object)action.getType());
        Validate.notNull(resource.getResolvedUri(version2));
        this.resource = resource;
        this.action = action;
        this.splitPath = new ArrayList<String>(Arrays.asList(this.resource.getResolvedUri(version2).split("/")));
        this.verb = action.getType().toString();
        this.mimeType = mimeType;
        this.version = version2;
        if (!this.splitPath.isEmpty()) {
            this.splitPath.remove(0);
            this.splitPath.remove(0);
        }
    }

    public String getVerb() {
        return this.verb;
    }

    public String getStringFromActionType() {
        switch (this.action.getType()) {
            case GET: {
                return "retrieve";
            }
            case POST: {
                return "update";
            }
            case PUT: {
                return "create";
            }
            case DELETE: {
                return "delete";
            }
        }
        return this.action.getType().toString().toLowerCase();
    }

    public String getExampleWrapper() {
        Map<String, Response> responses = this.action.getResponses();
        return this.getExampleWrapper(responses);
    }

    private String getExampleWrapper(Map<String, Response> responses) {
        String example;
        block3: {
            Response response;
            LinkedHashMap validResponses = responses.entrySet().stream().sorted(GenerationModel.getStatusCodeComparator()).collect(Collectors.toMap(e -> OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase((String)e.getKey()) ? "200" : (String)e.getKey(), Map.Entry::getValue, (k, v) -> v, LinkedHashMap::new));
            if (validResponses.isEmpty()) {
                return null;
            }
            Response responseOk = (Response)validResponses.get("200");
            example = null;
            if (responseOk != null) {
                example = GenerationModel.getExampleFromResponse(responseOk);
            }
            if (example != null) break block3;
            Iterator iterator = validResponses.values().iterator();
            while (iterator.hasNext() && (example = GenerationModel.getExampleFromResponse(response = (Response)iterator.next())) == null) {
            }
        }
        return example;
    }

    private static String getExampleFromResponse(Response response) {
        Map<String, String> examples = response.getExamples();
        if (examples.isEmpty()) {
            return null;
        }
        if (examples.containsKey("application/json")) {
            return examples.get("application/json");
        }
        return examples.values().iterator().next();
    }

    private static Comparator<Map.Entry<String, Response>> getStatusCodeComparator() {
        return (c1, c2) -> {
            String c1Key = (String)c1.getKey();
            String c2Key = (String)c2.getKey();
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c1Key) && OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c2Key)) {
                return 0;
            }
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c1Key)) {
                return -1;
            }
            if (OAS_DEFAULT_STATUS_CODE.equalsIgnoreCase(c2Key)) {
                return 1;
            }
            return c1Key.compareTo(c2Key);
        };
    }

    public Action getAction() {
        return this.action;
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        name.append(this.getStringFromActionType());
        String resourceName = this.resource.getDisplayName();
        if (resourceName == null) {
            StringBuffer buff = new StringBuffer();
            for (String i : this.splitPath) {
                buff.append(StringUtils.capitalize(i));
            }
            resourceName = buff.toString();
        }
        name.append(resourceName);
        if (this.mimeType != null) {
            MediaType mediaType = MediaType.parse(this.mimeType);
            StringBuffer buff = new StringBuffer();
            buff.append(StringUtils.capitalize(mediaType.getPrimaryType()));
            buff.append(StringUtils.capitalize(mediaType.getSubType()));
            name.append(buff.toString());
        }
        return name.toString().replace(" ", "");
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getRelativeURI() {
        return "/" + StringUtils.join(this.splitPath.toArray(), "/");
    }

    public Resource getResource() {
        return this.resource;
    }

    public ApikitMainFlowContainer getApi() {
        return this.api;
    }

    public String getFlowName() {
        StringBuilder flowName = new StringBuilder();
        flowName.append(this.action.getType().toString().toLowerCase()).append(":").append(FlowNameUtils.encodeColons(this.resource.getResolvedUri(this.version)));
        if (this.mimeType != null) {
            flowName.append(":").append(this.mimeType);
        }
        if (this.api.getConfig() != null && !StringUtils.isEmpty(this.api.getConfig().getName())) {
            flowName.append(":").append(this.api.getConfig().getName());
        }
        return FlowNameUtils.encode(flowName.toString());
    }

    @Override
    public int compareTo(@Nonnull GenerationModel generationModel) {
        return this.getName().compareTo(generationModel.getName());
    }

    public List<String> getUriParameters() {
        this.action.getResolvedUriParameters();
        Pattern uriParamsPattern = Pattern.compile("\\{([^}]+)\\}");
        ArrayList<String> result = new ArrayList<String>();
        String path = this.resource.getResolvedUri(this.version);
        Matcher matcher = uriParamsPattern.matcher(path);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

