/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import java.util.ArrayList;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Element;
import org.mule.tools.apikit.misc.ExampleUtils;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class APIKitFlowScope
implements Scope {
    private final Element flow = new Element("flow", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
    private static final String LOGGER_ATTRIBUTE_LEVEL = "level";
    private static final String LOGGER_ATTRIBUTE_MESSAGE = "message";
    private static final String LOGGER_ATTRIBUTE_LEVEL_VALUE = "INFO";

    public APIKitFlowScope(GenerationModel flowEntry) {
        this(flowEntry, true);
    }

    public APIKitFlowScope(GenerationModel flowEntry, boolean isMuleEE) {
        this.flow.setAttribute("name", flowEntry.getFlowName());
        if (isMuleEE && !flowEntry.getUriParameters().isEmpty()) {
            this.flow.addContent(this.createEEUriParamsSetVariables(flowEntry));
        } else if (!isMuleEE && !flowEntry.getUriParameters().isEmpty()) {
            for (Element element : this.createCEUriParamsSetVariables(flowEntry)) {
                this.flow.addContent(element);
            }
        }
        this.flow.addContent(this.generateFlowContent(flowEntry, isMuleEE));
    }

    private Element generateFlowContent(GenerationModel flowEntry, boolean isMuleEE) {
        if (isMuleEE && flowEntry.getExampleWrapper() != null) {
            try {
                return this.generateTransform(flowEntry);
            }
            catch (Exception e) {
                return this.generateLogger(flowEntry);
            }
        }
        return this.generateLogger(flowEntry);
    }

    private Element generateTransform(GenerationModel flowEntry) {
        Element transform2 = new Element("transform", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element setPayload = new Element("set-payload", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        Element message = new Element(LOGGER_ATTRIBUTE_MESSAGE, MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        CDATA cdataSection = new CDATA(this.generateTransformTextForExample(flowEntry.getExampleWrapper()));
        setPayload.addContent(cdataSection);
        message.setContent(setPayload);
        transform2.addNamespaceDeclaration(MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        transform2.setAttribute("name", "Transform Message", MuleConfigGenerator.DOC_NAMESPACE.getNamespace());
        transform2.addContent(message);
        return transform2;
    }

    private Element generateLogger(GenerationModel flowEntry) {
        Element logger = new Element("logger", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        logger.setAttribute(LOGGER_ATTRIBUTE_LEVEL, LOGGER_ATTRIBUTE_LEVEL_VALUE);
        logger.setAttribute(LOGGER_ATTRIBUTE_MESSAGE, flowEntry.getFlowName());
        return logger;
    }

    private Element createEEUriParamsSetVariables(GenerationModel flowEntry) {
        Element transform2 = new Element("transform", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        transform2.setAttribute("name", "Transform Message", MuleConfigGenerator.DOC_NAMESPACE.getNamespace());
        Element variables = new Element("variables", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
        for (String uriParameter : flowEntry.getUriParameters()) {
            Element setVariable = new Element("set-variable", MuleConfigGenerator.EE_NAMESPACE.getNamespace());
            setVariable.setAttribute("variableName", uriParameter);
            setVariable.addContent("attributes.uriParams.'" + uriParameter + "'");
            variables.addContent(setVariable);
        }
        transform2.addContent(variables);
        return transform2;
    }

    private List<Element> createCEUriParamsSetVariables(GenerationModel flowEntry) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String uriParameter : flowEntry.getUriParameters()) {
            Element element = new Element("set-variable", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
            element.setAttribute("value", "#[attributes.uriParams.'" + uriParameter + "']");
            element.setAttribute("variableName", uriParameter);
            result.add(element);
        }
        return result;
    }

    private String generateTransformTextForExample(String example) {
        return ExampleUtils.getDataWeaveExpressionText(example);
    }

    @Override
    public Element generate() {
        return this.flow;
    }
}

