/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import org.jdom2.Element;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.scopes.Scope;

public class HttpListenerConfigScope
implements Scope {
    private final Element httpListenerConfig;

    public HttpListenerConfigScope(HttpListenerConfig httpListenerConfig) {
        if (httpListenerConfig != null) {
            this.httpListenerConfig = new Element("listener-config", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            this.httpListenerConfig.setAttribute("name", httpListenerConfig.getName());
            String basePath = httpListenerConfig.getBasePath();
            if (basePath != null && basePath != "/" && basePath != "") {
                this.httpListenerConfig.setAttribute("basePath", httpListenerConfig.getBasePath());
            }
            Element connection = new Element("listener-connection", MuleConfigGenerator.HTTP_NAMESPACE.getNamespace());
            connection.setAttribute("host", httpListenerConfig.getHost());
            connection.setAttribute("port", httpListenerConfig.getPort());
            this.httpListenerConfig.addContent(connection);
            httpListenerConfig.setPersisted(true);
        } else {
            this.httpListenerConfig = null;
        }
    }

    @Override
    public Element generate() {
        return this.httpListenerConfig;
    }
}

