/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.output.scopes;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;
import org.mule.apikit.model.ActionType;
import org.mule.apikit.model.MimeType;
import org.mule.apikit.model.Resource;
import org.mule.apikit.model.Response;
import org.mule.apikit.model.parameter.Parameter;
import org.mule.tools.apikit.misc.DataWeaveExpressionUtils;
import org.mule.tools.apikit.misc.FlowNameUtils;
import org.mule.tools.apikit.misc.TestResourceNameGenerator;
import org.mule.tools.apikit.model.ScaffolderResource;
import org.mule.tools.apikit.output.GenerationModel;
import org.mule.tools.apikit.output.MuleConfigGenerator;
import org.mule.tools.apikit.output.MunitTestSuiteGenerator;
import org.mule.tools.apikit.output.scopes.HttpRequestScope;
import org.mule.tools.apikit.schemas.JsonSchemaDataGenerator;
import org.yaml.snakeyaml.Yaml;

public class MunitTestFlowScope {
    private static final String GET_RESOURCE_WRAPPER = "MunitTools::getResourceAsString('%s')";
    private static final String REQUEST_DIRECTORY = "request";
    private static final String RESPONSE_DIRECTORY = "response";
    private GenerationModel flowEntry;
    private String apikitFlowName;
    private boolean createResourceFiles;
    private Set<ScaffolderResource> generatedResources;

    public MunitTestFlowScope(GenerationModel flowEntry, String apikitFlowName) {
        this.flowEntry = flowEntry;
        this.apikitFlowName = apikitFlowName;
        this.generatedResources = new HashSet<ScaffolderResource>();
    }

    @Deprecated
    public Element generate() {
        return new Element("test", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
    }

    public List<Element> generateTests() {
        ArrayList<Element> elements = new ArrayList<Element>();
        Map<String, Response> flowIResponses = this.flowEntry.getAction().getResponses();
        for (Map.Entry<String, Response> responseEntry : flowIResponses.entrySet()) {
            String statusCode = responseEntry.getKey();
            Map<String, MimeType> responseBodies = responseEntry.getValue().getBody();
            if (null != responseBodies && !responseBodies.isEmpty()) {
                for (Map.Entry<String, MimeType> body2 : responseBodies.entrySet()) {
                    String mimeType = body2.getKey();
                    String examplePayload = this.buildExamplePayload(body2.getValue());
                    Element testFlow = this.generateTest(this.flowEntry, statusCode, mimeType, examplePayload);
                    elements.add(testFlow);
                }
                continue;
            }
            Element testFlow = this.generateTest(this.flowEntry, statusCode, "", "");
            elements.add(testFlow);
        }
        if (flowIResponses.isEmpty()) {
            Element testFlow = this.generateTest(this.flowEntry, "", "", "");
            elements.add(testFlow);
        }
        return elements;
    }

    public void setCreateResourceFiles(boolean createResourceFiles) {
        this.createResourceFiles = createResourceFiles;
    }

    private String buildExamplePayload(MimeType response) {
        String examplePayload;
        String string = examplePayload = response.getExample() == null ? "" : response.getExample();
        if (StringUtils.isBlank(examplePayload)) {
            String schemaString = response.getSchema();
            if (StringUtils.isNotBlank(schemaString) && "application/json".equals(response.getType())) {
                JsonParser parser2 = new JsonParser();
                try {
                    JsonObject jsonObj = (JsonObject)parser2.parse(schemaString);
                    return new JsonSchemaDataGenerator().buildExamplePayloadFromJsonSchema(jsonObj);
                }
                catch (ClassCastException e) {
                    return "";
                }
            }
            if (StringUtils.isNotBlank(schemaString) && "application/xml".equals(response.getType())) {
                return "";
            }
        } else if ("application/json".equals(response.getType())) {
            return MunitTestFlowScope.transformYamlExampleIntoJSON(examplePayload);
        }
        return examplePayload;
    }

    private static String transformYamlExampleIntoJSON(String example) {
        try {
            Yaml yaml = new Yaml();
            Object yamlObject = yaml.load(example);
            return new ObjectMapper().disableDefaultTyping().writeValueAsString(yamlObject);
        }
        catch (Throwable e) {
            return example;
        }
    }

    private Element generateTest(GenerationModel flowEntry, String statusCode, String mimeType, String examplePayload) {
        Element testFlow = this.generateMunitTestFlow(flowEntry, statusCode, mimeType);
        this.generateEnableFlowSources(flowEntry, testFlow);
        String uri = this.generateBehaviorSection(flowEntry, testFlow);
        this.generateExecutionSection(flowEntry, statusCode, mimeType, testFlow, uri);
        this.generateValidationSection(flowEntry, statusCode, mimeType, examplePayload, testFlow);
        return testFlow;
    }

    private void generateEnableFlowSources(GenerationModel flowEntry, Element testFlow) {
        Element enableFlowSources = new Element("enable-flow-sources", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        Element enableApikitFlow = new Element("enable-flow-source", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        enableApikitFlow.setAttribute("value", this.apikitFlowName);
        Element enableTestedFlow = new Element("enable-flow-source", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        enableTestedFlow.setAttribute("value", flowEntry.getFlowName());
        enableFlowSources.addContent(enableApikitFlow);
        enableFlowSources.addContent(enableTestedFlow);
        testFlow.addContent(enableFlowSources);
    }

    private String generateBehaviorSection(GenerationModel flowEntry, Element flow) {
        Element behavior = new Element("behavior", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        if (null != flowEntry.getAction() && this.isUpdateAction(flowEntry.getAction().getType())) {
            this.addRequestSetPayload(behavior, flowEntry);
        }
        String uri = this.addUriParametersVariables(behavior, flowEntry);
        if (!behavior.getChildren().isEmpty()) {
            flow.addContent(behavior);
        }
        return uri;
    }

    private void generateExecutionSection(GenerationModel flowEntry, String statusCode, String mimeType, Element flow, String uri) {
        Element execution = new Element("execution", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        this.addHttpRequest(execution, flowEntry, uri, statusCode, mimeType);
        if (!execution.getChildren().isEmpty()) {
            flow.addContent(execution);
        }
    }

    private void generateValidationSection(GenerationModel flowEntry, String statusCode, String mimeType, String examplePayload, Element flow) {
        Element validation = new Element("validation", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        this.addAssertTrueStatusCode(validation, statusCode);
        if (!StringUtils.isBlank(mimeType)) {
            this.addAssertOnEqualsPayload(validation, flowEntry, examplePayload, mimeType, statusCode);
        }
        if (!validation.getChildren().isEmpty()) {
            flow.addContent(validation);
        }
    }

    private Element generateMunitTestFlow(GenerationModel flowEntry, String statusCode, String mimeType) {
        String name = this.generateFlowName(flowEntry, mimeType, statusCode);
        Element flow = new Element("test", MunitTestSuiteGenerator.MUNIT_NAMESPACE.getNamespace());
        flow.setAttribute("name", name + "-FlowTest");
        flow.setAttribute("description", "Verifying functionality of [" + name + "]");
        return flow;
    }

    private String generateFlowName(GenerationModel flowEntry, String mimeType, String statusCode) {
        String flowName = flowEntry.getFlowName();
        if (flowEntry.getMimeType() != null) {
            String configName = flowEntry.getApi().getConfig().getName();
            String flowMimeType = flowEntry.getMimeType().replace("/", "\\");
            String expectedEndsWith = String.format("%s:%s", flowMimeType, configName);
            if (!flowName.endsWith(expectedEndsWith)) {
                flowName = flowEntry.getFlowName().replace(configName, expectedEndsWith);
            }
        }
        String name = flowName + "-" + statusCode + "-" + mimeType;
        return FlowNameUtils.encode(name);
    }

    private String addUriParametersVariables(Element flow, GenerationModel flowEntry) {
        Resource resource = flowEntry.getAction().getResource();
        return this.generateUriParameters(resource, flow);
    }

    private String generateUriParameters(Resource resource, Element flow) {
        if (null == resource.getParentUri()) {
            return resource.getRelativeUri();
        }
        String uri = resource.getUri();
        try {
            Map<String, Parameter> uriParameters = resource.getResolvedUriParameters();
            if (null != uriParameters && !uriParameters.isEmpty()) {
                for (Map.Entry<String, Parameter> uriParameterEntry : uriParameters.entrySet()) {
                    String parameterName = uriParameterEntry.getKey();
                    String parameterValue = uriParameterEntry.getValue().getDefaultValue();
                    if (StringUtils.isBlank(parameterValue)) {
                        parameterValue = uriParameterEntry.getValue().getExample();
                    }
                    Element element = this.buildSetVariable(parameterName, parameterValue);
                    flow.addContent(element);
                    uri = this.replaceUriParamsWithVariables(uri, parameterName);
                }
                return DataWeaveExpressionUtils.wrapInStringExpression(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    private Element buildSetVariable(String name, String value) {
        Element element = new Element("set-variable", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        element.setAttribute("variableName", name);
        element.setAttribute("value", DataWeaveExpressionUtils.wrapInStringExpression(value));
        element.setAttribute("name", name, MuleConfigGenerator.DOC_NAMESPACE.getNamespace());
        return element;
    }

    private String replaceUriParamsWithVariables(String uri, String parameterName) {
        String uriParamSegment = "{" + parameterName + "}";
        return uri.replace(uriParamSegment, "$(vars." + parameterName + ")");
    }

    private void addRequestSetPayload(Element flow, GenerationModel flowEntry) {
        Map<String, MimeType> requests = flowEntry.getAction().getBody();
        String requestType = flowEntry.getMimeType();
        if (null != requests && !requests.isEmpty()) {
            MimeType request = requests.containsKey(requestType) ? requests.get(requestType) : requests.get(requests.keySet().iterator().next());
            String requestPayload = this.buildExamplePayload(request);
            this.addSetPayload(flow, this.buildSetPayloadContent(flowEntry, requestPayload, requestType));
        }
    }

    private String buildSetPayloadContent(GenerationModel flowEntry, String requestPayload, String requestType) {
        String setPayloadContent = String.format("'%s'", requestPayload);
        if (this.createResourceFiles) {
            String fileName = TestResourceNameGenerator.generate(flowEntry, requestType, "");
            ScaffolderResource resource = new ScaffolderResource(REQUEST_DIRECTORY, fileName, IOUtils.toInputStream(requestPayload));
            this.generatedResources.add(resource);
            setPayloadContent = this.buildGetResourceFunction(resource);
        }
        return "#[" + setPayloadContent + "]";
    }

    private String buildGetResourceFunction(ScaffolderResource resource) {
        String relativePath = String.join((CharSequence)"/", "scaffolder", StringUtils.strip(resource.getDirectory(), "/"), resource.getName());
        return String.format(GET_RESOURCE_WRAPPER, relativePath);
    }

    private void addSetPayload(Element flow, String payload) {
        Element element = new Element("set-payload", MuleConfigGenerator.XMLNS_NAMESPACE.getNamespace());
        element.setAttribute("value", payload);
        flow.addContent(element);
    }

    private void addHttpRequest(Element flow, GenerationModel flowEntry, String uri, String statusCode, String mimeType) {
        HttpRequestScope requestScope = new HttpRequestScope(flowEntry, uri, mimeType, statusCode);
        flow.addContent(requestScope.generate());
    }

    private void addAssertTrueStatusCode(Element flow, String statusCode) {
        Element element = new Element("assert-that", MunitTestSuiteGenerator.MUNIT_TOOLS_NAMESPACE.getNamespace());
        element.setAttribute("expression", "#[attributes.statusCode]");
        element.setAttribute("is", DataWeaveExpressionUtils.wrapInEqualTo(statusCode));
        element.setAttribute("message", "The HTTP Status code is not correct!");
        String displayName = "Assert That Status Code is " + statusCode;
        element.setAttribute("name", displayName, MuleConfigGenerator.DOC_NAMESPACE.getNamespace());
        flow.addContent(element);
    }

    private void addAssertOnEqualsPayload(Element flow, GenerationModel flowEntry, String expectedPayload, String mimeType, String statusCode) {
        Element element = new Element("assert-that", MunitTestSuiteGenerator.MUNIT_TOOLS_NAMESPACE.getNamespace());
        expectedPayload = StringUtils.isBlank(expectedPayload) ? "" : expectedPayload.trim();
        element.setAttribute("expression", DataWeaveExpressionUtils.wrapInWriteToString("payload", mimeType));
        element.setAttribute("is", DataWeaveExpressionUtils.wrapInEqualTo(this.buildExpectedContent(flowEntry, expectedPayload, mimeType, statusCode)));
        element.setAttribute("message", "The response payload is not correct!");
        String displayName = "Assert That - Payload is Expected";
        element.setAttribute("name", displayName, MuleConfigGenerator.DOC_NAMESPACE.getNamespace());
        flow.addContent(element);
    }

    private String buildExpectedContent(GenerationModel flowEntry, String payload, String mimeType, String statusCode) {
        String expectedContent = String.format("'%s'", payload);
        if (this.createResourceFiles) {
            String fileName = TestResourceNameGenerator.generate(flowEntry, mimeType, statusCode);
            ScaffolderResource resource = new ScaffolderResource(RESPONSE_DIRECTORY, fileName, IOUtils.toInputStream(payload));
            this.generatedResources.add(resource);
            expectedContent = this.buildGetResourceFunction(resource);
        }
        return expectedContent;
    }

    private boolean isUpdateAction(ActionType type) {
        return ActionType.POST.equals((Object)type) || ActionType.PUT.equals((Object)type) || ActionType.PATCH.equals((Object)type);
    }

    public Set<ScaffolderResource> getGeneratedResources() {
        return Collections.unmodifiableSet(this.generatedResources);
    }
}

