/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.pojo.writer.converter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114AAB\u0004\u00011!)1\u0006\u0001C\u0001Y!)a\u0006\u0001C!_!)1\n\u0001C\u0001\u0019\")A\u000b\u0001C\u0001+\")!\f\u0001C\u00017\n)2)\u00197f]\u0012\f'\u000fR1uC\u000e{gN^3si\u0016\u0014(B\u0001\u0005\n\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u000b\u0017\u00051qO]5uKJT!\u0001D\u0007\u0002\tA|'n\u001c\u0006\u0003\u001d=\ta!\\8ek2,'B\u0001\t\u0012\u0003\t1(G\u0003\u0002\u0013'\u0005)q/Z1wK*\u0011A#F\u0001\u0005[VdWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u0001\n3%D\u0001\b\u0013\t\u0011sAA\u0007ECR\f7i\u001c8wKJ$XM\u001d\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA!\u001e;jY*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005!\u0019\u0015\r\\3oI\u0006\u0014\u0018A\u0002\u001fj]&$h\bF\u0001.!\t\u0001\u0003!A\u0004d_:4XM\u001d;\u0015\u0007Ab\u0014\t\u0006\u00022iA\u0019!DM\u0012\n\u0005MZ\"AB(qi&|g\u000eC\u00036\u0005\u0001\u000fa'A\u0002dib\u0004\"a\u000e\u001e\u000e\u0003aR!!O\b\u0002\u000b5|G-\u001a7\n\u0005mB$!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\")QH\u0001a\u0001}\u000511o\\;sG\u0016\u0004\"AG \n\u0005\u0001[\"aA!os\")!I\u0001a\u0001\u0007\u000611o\u00195f[\u0006\u00042A\u0007\u001aE!\t)\u0015*D\u0001G\u0015\t\u0011uI\u0003\u0002Iq\u0005I1\u000f\u001e:vGR,(/Z\u0005\u0003\u0015\u001a\u0013aaU2iK6\f\u0017AC1t\u0007\u0006dWM\u001c3beR\u00111%\u0014\u0005\u0006\u001d\u000e\u0001\raT\u0001\u0005i&lW\r\u0005\u0002Q%6\t\u0011K\u0003\u0002OO%\u00111+\u0015\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u0017\u001d,G\u000fV5nKj{g.\u001a\u000b\u0003-f\u0003\"\u0001J,\n\u0005a+#\u0001\u0003+j[\u0016TvN\\3\t\u000b9#\u0001\u0019A(\u0002-\u0019\fG\u000e\u001c2bG.\u001cFO]5oO\u000e{WM]2j_:$\"a\u0014/\t\u000bu+\u0001\u0019\u00010\u0002\u0007M$(\u000f\u0005\u0002`E6\t\u0001M\u0003\u0002bO\u0005!A.\u00198h\u0013\t\u0019\u0007M\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r")
public class CalendarDataConverter
implements DataConverter<Calendar> {
    @Override
    public Option<String> format(Map<String, Object> arguments) {
        return DataConverter.format$(this, arguments);
    }

    @Override
    public Option<String> separator(Map<String, Object> arguments) {
        return DataConverter.separator$(this, arguments);
    }

    @Override
    public Option<String> encoding(Map<String, Object> arguments) {
        return DataConverter.encoding$(this, arguments);
    }

    @Override
    public Option<Calendar> convert(Object source, Option<Schema> schema, EvaluationContext ctx) {
        Calendar calendar;
        Object object = source;
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
            instance.set(14, localDateTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            calendar = this.asCalendar(zonedDateTime);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(11, localTime.getHour());
            instance.set(12, localTime.getMinute());
            instance.set(13, localTime.getSecond());
            instance.set(14, localTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            Calendar instance = Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset().getId()));
            instance.set(11, offsetTime.getHour());
            instance.set(12, offsetTime.getMinute());
            instance.set(13, offsetTime.getSecond());
            instance.set(14, offsetTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            Calendar instance = Calendar.getInstance();
            instance.set(2, localDate.getMonthValue() - 1);
            instance.set(5, localDate.getDayOfMonth());
            instance.set(1, localDate.getYear());
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            calendar = instance;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            Calendar instance = Calendar.getInstance();
            instance.setTime(new Date(l));
            calendar = instance;
        } else if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            ZonedDateTime zonedDateTime = this.fallbackStringCoercion(charSequence);
            calendar = this.asCalendar(zonedDateTime);
        } else {
            Calendar calendar2;
            calendar = object instanceof Calendar ? (calendar2 = (Calendar)object) : null;
        }
        Calendar calendar3 = calendar;
        return Option$.MODULE$.apply(calendar3);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar asCalendar(ZonedDateTime time) {
        void var2_2;
        Calendar instance = Calendar.getInstance(this.getTimeZone(time));
        instance.set(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
        instance.set(14, time.get(ChronoField.MILLI_OF_SECOND));
        return var2_2;
    }

    public TimeZone getTimeZone(ZonedDateTime time) {
        String string;
        String string2 = time.getZone().getId();
        TimeZone timeZone = string2 != null && (string = string2).matches("[+-][0-9]{2}:[0-9]{2}") ? TimeZone.getTimeZone(new StringBuilder(3).append("GMT").append(time.getZone().getId()).toString()) : TimeZone.getTimeZone(time.getZone().getId());
        return timeZone;
    }

    public ZonedDateTime fallbackStringCoercion(CharSequence str) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0<ZonedDateTime> & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str)).orElse((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<ZonedDateTime> & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).atZone(ZoneOffset.UTC))).get();
    }

    public CalendarDataConverter() {
        DataConverter.$init$(this);
    }
}

