/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.mule.weave.v2.debugger.util.FileElement;
import org.mule.weave.v2.debugger.util.InputElementFactory$;
import org.mule.weave.v2.interpreted.DefaultRuntimeModuleNodeCompiler;
import org.mule.weave.v2.interpreted.InterpretedMappingExecutableWeave;
import org.mule.weave.v2.interpreted.InterpretedModuleExecutableWeave;
import org.mule.weave.v2.interpreted.InterpreterMappingCompilerPhase;
import org.mule.weave.v2.interpreted.InterpreterModuleCompilerPhase;
import org.mule.weave.v2.interpreted.debugger.server.DefaultWeaveDebuggingSession;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerProtocol;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerProtocol$;
import org.mule.weave.v2.interpreted.module.WeaveDataFormat;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.DocumentParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.CommonSubexpressionReductionPhase;
import org.mule.weave.v2.parser.phase.CompilationPhase;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.ExecutableWeaveHelper$;
import org.mule.weave.v2.runtime.utils.AnsiColor$;
import org.mule.weave.v2.runtime.utils.CustomRunner;
import org.mule.weave.v2.runtime.utils.RunnerConfiguration;
import org.mule.weave.v2.runtime.utils.WeaveRuntimeUtils$;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.util.Either;

public final class DefaultCustomRunner$
implements CustomRunner {
    public static DefaultCustomRunner$ MODULE$;

    static {
        new DefaultCustomRunner$();
    }

    @Override
    public String runnerName() {
        return "default";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Either<RunnerConfiguration, String> parseArgs(String[] args) {
        Either either2;
        PrintStream printStream = System.out;
        Seq inputs = Nil$.MODULE$;
        None$ none$ = None$.MODULE$;
        Seq parameters = Nil$.MODULE$;
        boolean debug = false;
        WeaveResource resource = null;
        NameIdentifier nameIdentifier = null;
        if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty()) {
            either2 = package$.MODULE$.Right().apply("Data Weave Name Identifier was not specified.");
            return either2;
        }
        File file = new File((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).last());
        if (!file.exists()) {
            WeaveResource value;
            nameIdentifier = new NameIdentifier((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).last(), NameIdentifier$.MODULE$.apply$default$2());
            Option<WeaveResource> mayBeUrl = ClassLoaderWeaveResourceResolver$.MODULE$.apply().resolve(nameIdentifier);
            Option<WeaveResource> option = mayBeUrl;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return package$.MODULE$.Right().apply(new StringBuilder(26).append("Unable to load weave file ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).last()).toString());
            }
            Some some = (Some)option;
            resource = value = (WeaveResource)some.value();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            resource = WeaveResourceFactory$.MODULE$.fromFile(file);
            String filePath = file.getPath();
            String basePath = new File(".").getAbsolutePath();
            String path = filePath;
            if (filePath.startsWith(basePath)) {
                path = filePath.substring(basePath.length());
            }
            nameIdentifier = NameIdentifier$.MODULE$.fromPath(path);
        }
        String[] configArgs = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])args)).slice(0, args.length - 1);
        int index = 0;
        while (true) {
            BoxedUnit boxedUnit;
            if (index >= configArgs.length) {
                void var5_3;
                void var7_7;
                either2 = package$.MODULE$.Left().apply(new RunnerConfiguration(resource, nameIdentifier, (Option<File>)var7_7, (OutputStream)var5_3, inputs, parameters, debug));
                return either2;
            }
            String string = configArgs[index];
            if ("-input".equals(string)) {
                if (index + 2 >= configArgs.length) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red("Invalid amount of arguments on input."));
                File input = new File(configArgs[index + 2]);
                String inputName = configArgs[index + 1];
                if (!input.exists()) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red(new StringBuilder(21).append("Invalid input file ").append(inputName).append(" ").append(input.getAbsolutePath()).append(".").toString()));
                inputs = inputs.$colon$plus(new Tuple2<String, File>(inputName, input), Seq$.MODULE$.canBuildFrom());
                index += 2;
                boxedUnit = BoxedUnit.UNIT;
            } else if ("-scenario".equals(string)) {
                if (index + 1 >= configArgs.length) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red("Invalid amount of arguments on `scenario`."));
                File dir = new File(configArgs[index + 1]);
                if (!dir.exists()) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red(new StringBuilder(28).append("`scenario` ").append(dir.getAbsolutePath()).append(" does not exists.").toString()));
                if (!dir.isDirectory()) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red(new StringBuilder(31).append("`scenario` ").append(dir.getAbsolutePath()).append(" is not a directory.").toString()));
                Some<File> some = new Some<File>(dir);
                ++index;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl = "-param".equals(string) ? true : "-p".equals(string);
                if (bl) {
                    if (index + 1 >= configArgs.length) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red("Invalid amount of arguments on `param`."));
                    String paramValue = configArgs[index + 1];
                    parameters = parameters.$colon$plus(paramValue, Seq$.MODULE$.canBuildFrom());
                    index += 2;
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("-output".equals(string)) {
                    if (index + 1 >= configArgs.length) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red("Invalid amount of arguments on output."));
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(configArgs[index + 1]));
                    ++index;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!"-debug".equals(string)) return package$.MODULE$.Right().apply(AnsiColor$.MODULE$.red(new StringBuilder(18).append("Invalid argument ").append(string).append(".").toString()));
                    debug = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ParsingContext createParsingContextFor(RunnerConfiguration configuration, NameIdentifier nameIdentifier) {
        void var3_3;
        ParsingContext parsingContext = ParsingContextFactory$.MODULE$.createParsingContext(nameIdentifier);
        configuration.inputs().foreach((Function1<Tuple2, ParsingContext> & Serializable & scala.Serializable)input -> parsingContext.addImplicitInput((String)input._1(), None$.MODULE$));
        this.org$mule$weave$v2$runtime$utils$DefaultCustomRunner$$contextValues(configuration).foreach((Function1<Tuple2, ParsingContext> & Serializable & scala.Serializable)entry -> parsingContext.addImplicitInput((String)entry._1(), None$.MODULE$));
        return var3_3;
    }

    public void run(RunnerConfiguration config) {
        WeaveResource resource = config.resource();
        NameIdentifier nameIdentifier = config.nameIdentifier();
        ParsingContext parsingContext = this.createParsingContextFor(config, nameIdentifier);
        DocumentParser documentParser = new DocumentParser(DocumentParser$.MODULE$.$lessinit$greater$default$1(), DocumentParser$.MODULE$.$lessinit$greater$default$2());
        PhaseResult<ParsingResult<AstNode>> parse = documentParser.parse(resource, parsingContext);
        PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult = documentParser.typeCheck(documentParser.scopeCheck(documentParser.canonical(parse, parsingContext), parsingContext), parsingContext);
        Seq<Tuple2<WeaveLocation, Message>> warningMessages = typeCheckResult.warningMessages();
        if (typeCheckResult.hasResult()) {
            int n;
            TypeCheckingResult<? extends AstNode> result;
            Object t2;
            if (warningMessages.nonEmpty()) {
                warningMessages.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)message -> {
                    Predef$.MODULE$.println(AnsiColor$.MODULE$.yellow(new StringBuilder(17).append("[Warning] ").append(((Message)message._2()).message()).append(".").append(" {").append(((WeaveLocation)message._1()).startPosition().line()).append(":").append(((WeaveLocation)message._1()).startPosition().column()).append("}:\n").append(((WeaveLocation)message._1()).locationString()).toString()));
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println(new StringBuilder(22).append(warningMessages.size()).append(" Warnings where found.").toString());
            }
            if ((t2 = (result = typeCheckResult.getResult()).astNode()) instanceof DocumentNode) {
                n = this.runMapping(config, parsingContext, typeCheckResult);
            } else if (t2 instanceof ModuleNode) {
                n = this.runModule(config, parsingContext, typeCheckResult);
            } else {
                throw new MatchError(t2);
            }
            int statusCode = n;
            System.exit(statusCode);
        } else {
            Predef$.MODULE$.println(typeCheckResult.messages().errorMessageString());
            Predef$.MODULE$.println(typeCheckResult.messages().warningMessageString());
            if (typeCheckResult.hasErrors() || typeCheckResult.isEmpty()) {
                Predef$.MODULE$.println(AnsiColor$.MODULE$.red(new StringBuilder(20).append(typeCheckResult.errorMessages().size()).append(" Errors where found.").toString()));
                System.exit(1);
                return;
            }
        }
    }

    @Override
    public void usage() {
        Predef$.MODULE$.println("[-input <name> <value>]* [-scenario <path>] [-param | -p <paramValue>]* [-debug]? [-output <path>]? <weave file path>");
    }

    public int runModule(RunnerConfiguration config, ParsingContext parsingContext, PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult) {
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply();
        Map<String, Value<?>> values = ((TraversableOnce)((TraversableLike)config.parameters().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)valueIndex -> new Tuple2<String, StringValue>(Integer.toString(valueIndex._2$mcI$sp()), StringValue$.MODULE$.apply((String)valueIndex._1())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
        PhaseResult result = new InterpreterModuleCompilerPhase(new DefaultRuntimeModuleNodeCompiler()).call(value, parsingContext);
        ExecutableWeave engine = ((CompilationResult)result.getResult()).executable();
        IntRef responseCode = IntRef.create(0);
        if (config.debug()) {
            CountDownLatch latch = new CountDownLatch(1);
            TcpServerProtocol protocol = TcpServerProtocol$.MODULE$.apply(TcpServerProtocol$.MODULE$.apply$default$1());
            DefaultWeaveDebuggingSession debuggingSession = ((InterpretedModuleExecutableWeave)engine).debug(protocol);
            debuggingSession.addSessionListener(() -> new Thread(values, engine, ctx, responseCode, protocol, latch){
                private final Map values$1;
                private final ExecutableWeave engine$1;
                private final EvaluationContext ctx$1;
                private final IntRef responseCode$1;
                private final TcpServerProtocol protocol$1;
                private final CountDownLatch latch$1;

                public void run() {
                    try {
                        Map x$1 = this.values$1;
                        Map<String, Reader> x$2 = this.engine$1.execute$default$1();
                        Value<?> value = this.engine$1.execute(x$2, x$1, this.ctx$1);
                        if (NumberType$.MODULE$.accepts(value, this.ctx$1)) {
                            this.responseCode$1.elem = ((Number)NumberType$.MODULE$.coerce(value, this.ctx$1).evaluate(this.ctx$1)).toInt();
                        }
                        this.protocol$1.disconnect();
                        this.latch$1.countDown();
                    }
                    finally {
                        this.ctx$1.close();
                    }
                }
                {
                    this.values$1 = values$1;
                    this.engine$1 = engine$1;
                    this.ctx$1 = ctx$1;
                    this.responseCode$1 = responseCode$1;
                    this.protocol$1 = protocol$1;
                    this.latch$1 = latch$1;
                }
            }.start());
            Predef$.MODULE$.println("[dw-debugger] Waiting for debugger client to connect.");
            latch.await();
        } else {
            try {
                Map<String, Value<?>> x$1 = values;
                Map<String, Reader> x$2 = engine.execute$default$1();
                Value<?> value2 = engine.execute(x$2, x$1, ctx);
                if (NumberType$.MODULE$.accepts(value2, ctx)) {
                    responseCode.elem = ((Number)NumberType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toInt();
                }
            }
            finally {
                ctx.close();
            }
        }
        return responseCode.elem;
    }

    public int runMapping(RunnerConfiguration config, ParsingContext parsingContext, PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult) {
        Serializable serializable;
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply();
        TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
        CompilationPhase compiler = new CommonSubexpressionReductionPhase().chainWith(new InterpreterMappingCompilerPhase(new DefaultRuntimeModuleNodeCompiler()));
        PhaseResult<CompilationResult<DocumentNode>> result = compiler.call(value, parsingContext);
        ExecutableWeave<DocumentNode> engine = result.getResult().executable();
        if (config.debug()) {
            CountDownLatch latch = new CountDownLatch(1);
            TcpServerProtocol protocol = TcpServerProtocol$.MODULE$.apply(TcpServerProtocol$.MODULE$.apply$default$1());
            DefaultWeaveDebuggingSession debuggingSession = ((InterpretedMappingExecutableWeave)engine).debug(protocol);
            debuggingSession.addSessionListener(() -> new Thread(config, engine, ctx, protocol, latch){
                private final RunnerConfiguration config$1;
                private final ExecutableWeave engine$2;
                private final EvaluationContext ctx$2;
                private final TcpServerProtocol protocol$2;
                private final CountDownLatch latch$2;

                public void run() {
                    Map<String, Value<?>> values = DefaultCustomRunner$.MODULE$.org$mule$weave$v2$runtime$utils$DefaultCustomRunner$$contextValues(this.config$1);
                    this.engine$2.writeWith(ExecutableWeaveHelper$.MODULE$.buildWriter(this.engine$2, this.config$1.output(), new Some<DataFormat<?, ?>>(new WeaveDataFormat()), this.ctx$2), ExecutableWeaveHelper$.MODULE$.buildReaders(this.engine$2, this.config$1.inputs().toMap(Predef$.MODULE$.$conforms()), this.ctx$2), values, this.engine$2.writeWith$default$4(), this.ctx$2);
                    this.protocol$2.disconnect();
                    this.latch$2.countDown();
                }
                {
                    this.config$1 = config$1;
                    this.engine$2 = engine$2;
                    this.ctx$2 = ctx$2;
                    this.protocol$2 = protocol$2;
                    this.latch$2 = latch$2;
                }
            }.start());
            Predef$.MODULE$.println("[dw-debugger] Waiting for debugger client to connect.");
            latch.await();
            serializable = BoxedUnit.UNIT;
        } else {
            Map<String, Value<?>> values = this.org$mule$weave$v2$runtime$utils$DefaultCustomRunner$$contextValues(config);
            serializable = engine.writeWith(ExecutableWeaveHelper$.MODULE$.buildWriter(engine, config.output(), new Some(new WeaveDataFormat()), ctx), ExecutableWeaveHelper$.MODULE$.buildReaders(engine, config.inputs().toMap(Predef$.MODULE$.$conforms()), ctx), values, engine.writeWith$default$4(), ctx);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Value<?>> org$mule$weave$v2$runtime$utils$DefaultCustomRunner$$contextValues(RunnerConfiguration config) {
        void var2_2;
        Map values = (Map)config.scenarioDir().map((Function1<File, Map> & Serializable & scala.Serializable)folder2 -> {
            FileElement[] elements = InputElementFactory$.MODULE$.fromDirectory(new File((File)folder2, "inputs").listFiles());
            return WeaveRuntimeUtils$.MODULE$.toContext(elements);
        }).getOrElse((Function0<Map> & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$));
        return var2_2;
    }

    private DefaultCustomRunner$() {
        MODULE$ = this;
    }
}

