/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.math.BigDecimal;
import org.raml.model.parameter.AbstractParam;

public enum ParamType {
    STRING{

        @Override
        public String message(AbstractParam param2, String value) {
            if (param2.getPattern() != null && !value.matches(param2.getPattern())) {
                return "Value does not match pattern " + param2.getPattern();
            }
            if (param2.getMinLength() != null && value.length() < param2.getMinLength()) {
                return "Value length is shorter than " + param2.getMinLength();
            }
            if (param2.getMaxLength() != null && value.length() > param2.getMaxLength()) {
                return "Value length is longer than " + param2.getMaxLength();
            }
            if (param2.getEnumeration() != null && !param2.getEnumeration().contains(value)) {
                return "Value must be one of " + param2.getEnumeration();
            }
            return ParamType.OK;
        }
    }
    ,
    NUMBER{

        @Override
        public String message(AbstractParam param2, String value) {
            BigDecimal number;
            try {
                number = new BigDecimal(value);
            }
            catch (NumberFormatException nfe) {
                return "Number required";
            }
            if (param2.getMinimum() != null && number.compareTo(param2.getMinimum()) < 0) {
                return "Value is below the minimum " + param2.getMinimum();
            }
            if (param2.getMaximum() != null && number.compareTo(param2.getMaximum()) > 0) {
                return "Value is above the maximum " + param2.getMaximum();
            }
            return ParamType.OK;
        }
    }
    ,
    INTEGER{

        @Override
        public String message(AbstractParam param2, String value) {
            Integer number;
            try {
                number = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return "Integer required";
            }
            if (param2.getMinimum() != null && BigDecimal.valueOf(number.intValue()).compareTo(param2.getMinimum()) < 0) {
                return "Value is below the minimum " + param2.getMinimum();
            }
            if (param2.getMaximum() != null && BigDecimal.valueOf(number.intValue()).compareTo(param2.getMaximum()) > 0) {
                return "Value is above the maximum " + param2.getMaximum();
            }
            return ParamType.OK;
        }
    }
    ,
    DATE,
    FILE,
    BOOLEAN{

        @Override
        public String message(AbstractParam param2, String value) {
            if ("true".equals(value) || "false".equals(value)) {
                return ParamType.OK;
            }
            return "Value must be one of [true, false]";
        }
    };

    public static final String OK = "OK";

    public boolean validate(AbstractParam param2, String value) {
        return OK.equals(this.message(param2, value));
    }

    public String message(AbstractParam param2, String value) {
        return OK;
    }
}

