/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.DocumentationItem;
import org.raml.model.Protocol;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.SecurityScheme;
import org.raml.model.Template;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.builder.GlobalSchemaSequenceTupleBuilder;
import org.raml.parser.builder.ProtocolBuilder;
import org.raml.parser.resolver.ResourceHandler;
import org.raml.parser.rule.BaseUriRule;
import org.raml.parser.rule.GlobalSchemasRule;
import org.raml.parser.rule.ProtocolRule;
import org.raml.parser.rule.SecurityReferenceSequenceRule;
import org.raml.parser.rule.UriParametersRule;

public class Raml
implements Serializable {
    private static final long serialVersionUID = -7107368438040691199L;
    @Scalar(required=true)
    private String title;
    @Scalar
    private String version;
    @Scalar(rule=BaseUriRule.class)
    private String baseUri;
    @Sequence(rule=ProtocolRule.class, builder=ProtocolBuilder.class)
    private List<Protocol> protocols = new ArrayList<Protocol>();
    @Mapping(rule=UriParametersRule.class)
    private Map<String, UriParameter> baseUriParameters = new LinkedHashMap<String, UriParameter>();
    @Scalar
    private String mediaType;
    @Sequence(rule=GlobalSchemasRule.class, builder=GlobalSchemaSequenceTupleBuilder.class)
    private List<Map<String, String>> schemas = new ArrayList<Map<String, String>>();
    private transient Map<String, Object> compiledSchemas;
    @Sequence
    private List<Map<String, Template>> resourceTypes = new ArrayList<Map<String, Template>>();
    @Sequence
    private List<Map<String, Template>> traits = new ArrayList<Map<String, Template>>();
    @Sequence
    private List<Map<String, SecurityScheme>> securitySchemes = new ArrayList<Map<String, SecurityScheme>>();
    @Sequence(rule=SecurityReferenceSequenceRule.class)
    private List<SecurityReference> securedBy = new ArrayList<SecurityReference>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    @Sequence
    private List<DocumentationItem> documentation;

    public void setDocumentation(List<DocumentationItem> documentation) {
        this.documentation = documentation;
    }

    public List<DocumentationItem> getDocumentation() {
        return this.documentation;
    }

    public void setBaseUriParameters(Map<String, UriParameter> uriParameters) {
        this.baseUriParameters = uriParameters;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBasePath() {
        int start = this.baseUri.indexOf("//") + 2;
        if (start == -1) {
            start = 0;
        }
        start = this.baseUri.indexOf("/", start);
        return this.baseUri.substring(start);
    }

    public String getUri() {
        return "";
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public Map<String, UriParameter> getBaseUriParameters() {
        return this.baseUriParameters;
    }

    public List<Map<String, Template>> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(List<Map<String, Template>> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public List<Map<String, Template>> getTraits() {
        return this.traits;
    }

    public void setTraits(List<Map<String, Template>> traits2) {
        this.traits = traits2;
    }

    public List<Map<String, String>> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<Map<String, String>> schemas) {
        this.schemas = schemas;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(List<Map<String, SecurityScheme>> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public List<SecurityReference> getSecuredBy() {
        return this.securedBy;
    }

    public void setSecuredBy(List<SecurityReference> securedBy) {
        this.securedBy = securedBy;
    }

    public Map<String, String> getConsolidatedSchemas() {
        HashMap<String, String> consolidated = new HashMap<String, String>();
        for (Map<String, String> map : this.getSchemas()) {
            consolidated.putAll(map);
        }
        return consolidated;
    }

    public Map<String, Object> getCompiledSchemas() {
        return this.compiledSchemas;
    }

    public void setCompiledSchemas(Map<String, Object> compiledSchemas) {
        this.compiledSchemas = compiledSchemas;
    }

    public Resource getResource(String path) {
        for (Resource resource : this.resources.values()) {
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/') continue;
            return resource.getResource(path.substring(resource.getRelativeUri().length()));
        }
        return null;
    }
}

