/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import java.io.ByteArrayOutputStream;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeHandler;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class JacksonTagResolver
implements TagResolver {
    public static final Tag JACKSON_TAG = new Tag("!jackson");

    @Override
    public boolean handles(Tag tag2) {
        return JACKSON_TAG.equals(tag2);
    }

    @Override
    public Node resolve(Node node, ResourceLoader resourceLoader, NodeHandler nodeHandler) {
        String className = ((ScalarNode)node).getValue();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disableDefaultTyping();
            SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
            objectMapper.acceptJsonFormatVisitor(objectMapper.constructType(clazz), (JsonFormatVisitorWrapper)visitor);
            JsonSchema jsonSchema = visitor.finalSchema();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            objectMapper.writeValue(baos, (Object)jsonSchema);
            String schema = baos.toString();
            return new ScalarNode(Tag.STR, schema, node.getStartMark(), node.getEndMark(), ((ScalarNode)node).getScalarStyle());
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    @Override
    public void beforeProcessingResolvedNode(Tag tag2, Node originalValueNode, Node resolvedNode) {
    }

    @Override
    public void afterProcessingResolvedNode(Tag tag2, Node originalValueNode, Node resolvedNode) {
    }
}

