/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.CompoundIncludeResolver;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.JacksonTagResolver;
import org.raml.parser.tagresolver.JaxbTagResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.MediaTypeResolver;
import org.raml.parser.visitor.SchemaCompiler;
import org.raml.parser.visitor.TemplateResolver;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlDocumentBuilder;
import org.yaml.snakeyaml.nodes.MappingNode;

public class RamlDocumentBuilder
extends YamlDocumentBuilder<Raml> {
    private TemplateResolver templateResolver;
    private MediaTypeResolver mediaTypeResolver;

    public RamlDocumentBuilder() {
        this(new DefaultResourceLoader(), new TagResolver[0]);
    }

    public RamlDocumentBuilder(ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        super(Raml.class, resourceLoader, RamlDocumentBuilder.defaultResolver(tagResolvers));
    }

    private static TagResolver[] defaultResolver(TagResolver[] tagResolvers) {
        Object[] defaultResolvers = new TagResolver[]{new IncludeResolver(), new CompoundIncludeResolver(), new JacksonTagResolver(), new JaxbTagResolver()};
        return (TagResolver[])ArrayUtils.addAll(defaultResolvers, tagResolvers);
    }

    @Override
    public boolean onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
        super.onMappingNodeStart(mappingNode, tupleType);
        if (this.getDocumentContext().peek() instanceof Resource) {
            Resource resource = (Resource)this.getDocumentContext().peek();
            this.getTemplateResolver().resolve(mappingNode, resource.getRelativeUri(), resource.getUri());
        } else if (this.isBodyBuilder(this.getBuilderContext().peek())) {
            this.getMediaTypeResolver().resolve(mappingNode);
        }
        return true;
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode, TupleType tupleType) {
        if (this.getDocumentContext().peek() instanceof Resource) {
            Resource resource = (Resource)this.getDocumentContext().peek();
            this.populateDefaultUriParameters(resource);
        }
        super.onMappingNodeEnd(mappingNode, tupleType);
    }

    private String toString(Stack<NodeBuilder<?>> builderContext) {
        StringBuilder builder = new StringBuilder(">>> BuilderContext >>> ");
        for (NodeBuilder nodeBuilder : builderContext) {
            builder.append(nodeBuilder).append(" ->- ");
        }
        return builder.toString();
    }

    private boolean isBodyBuilder(NodeBuilder builder) {
        try {
            Field valueType = builder.getClass().getDeclaredField("valueClass");
            valueType.setAccessible(true);
            return valueType.get(builder) != null && ((Class)valueType.get(builder)).getName().equals("org.raml.model.MimeType");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public TemplateResolver getTemplateResolver() {
        if (this.templateResolver == null) {
            this.templateResolver = new TemplateResolver(this.getResourceLoader(), this);
        }
        return this.templateResolver;
    }

    public MediaTypeResolver getMediaTypeResolver() {
        if (this.mediaTypeResolver == null) {
            this.mediaTypeResolver = new MediaTypeResolver();
        }
        return this.mediaTypeResolver;
    }

    @Override
    protected void preBuildProcess() {
        this.getTemplateResolver().init(this.getRootNode());
        this.getMediaTypeResolver().beforeDocumentStart(this.getRootNode());
    }

    @Override
    protected void postBuildProcess() {
        this.getMediaTypeResolver().setBodyDefaultMediaType(((Raml)this.getDocumentObject()).getResources());
        this.compileGlobalSchemas();
    }

    private void compileGlobalSchemas() {
        SchemaCompiler compiler = SchemaCompiler.getInstance();
        Raml raml = (Raml)this.getDocumentObject();
        HashMap<String, Object> compiledSchemas = new HashMap<String, Object>();
        List<Map<String, String>> schemas = raml.getSchemas();
        for (Map<String, String> schemaMap : schemas) {
            compiledSchemas.putAll(compiler.compile(schemaMap));
        }
        raml.setCompiledSchemas(compiledSchemas);
    }

    private void populateDefaultUriParameters(Resource resource) {
        Pattern pattern = Pattern.compile("[.*]?\\{(\\w+)?\\}[.*]*");
        Matcher matcher = pattern.matcher(resource.getRelativeUri());
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (resource.getUriParameters().containsKey(paramName)) continue;
            resource.getUriParameters().put(paramName, new UriParameter(paramName));
        }
    }
}

