/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.loader.ResourceLoaderAware;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.SequenceRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlValidator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlDocumentValidator
implements YamlValidator {
    private Class<?> documentClass;
    private Stack<NodeRule<?>> ruleContext = new Stack();
    private List<ValidationResult> messages = new ArrayList<ValidationResult>();
    private NodeRuleFactory nodeRuleFactory;
    private ContextPath contextPath;
    private ResourceLoader resourceLoader;

    protected YamlDocumentValidator(Class<?> documentClass) {
        this(documentClass, new NodeRuleFactory(new NodeRuleFactoryExtension[0]));
    }

    protected YamlDocumentValidator(Class<?> documentClass, NodeRuleFactory nodeRuleFactory) {
        this.documentClass = documentClass;
        this.nodeRuleFactory = nodeRuleFactory;
    }

    protected Stack<NodeRule<?>> getRuleContext() {
        return this.ruleContext;
    }

    @Override
    public boolean onMappingNodeStart(MappingNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            this.addMessage(ValidationResult.createErrorResult("Only scalar keys are allowed", node));
        }
        return true;
    }

    @Override
    public void onMappingNodeEnd(MappingNode node, TupleType tupleType) {
    }

    @Override
    public boolean onSequenceStart(SequenceNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            this.addMessage(ValidationResult.createErrorResult("Only scalar keys are allowed", node));
        } else {
            NodeRule<?> peek = this.ruleContext.peek();
            this.addMessages(peek.validateValue(node));
        }
        return true;
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        NodeRule<?> peek = this.ruleContext.peek();
        List<ValidationResult> result = tupleType == TupleType.VALUE ? peek.validateValue(node) : ((TupleRule)peek).validateKey(node);
        this.addMessages(result);
    }

    private void addMessages(List<ValidationResult> result) {
        for (ValidationResult validationResult : result) {
            validationResult.setIncludeContext(this.contextPath);
            this.messages.add(validationResult);
        }
    }

    private void addMessage(ValidationResult errorResult) {
        this.addMessages(Collections.singletonList(errorResult));
    }

    @Override
    public boolean onDocumentStart(MappingNode node) {
        this.ruleContext.push(this.buildDocumentRule());
        return true;
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        NodeRule<?> pop = this.ruleContext.pop();
        List<ValidationResult> onRuleEnd = pop.onRuleEnd();
        this.addMessages(onRuleEnd);
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        NodeRule<?> rule = this.ruleContext.pop();
        if (rule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        List<ValidationResult> onRuleEnd = rule.onRuleEnd();
        this.addMessages(onRuleEnd);
    }

    @Override
    public boolean onTupleStart(NodeTuple nodeTuple) {
        TupleRule<?, ?> rule;
        TupleRule tupleRule = (TupleRule)this.ruleContext.peek();
        if (tupleRule != null) {
            rule = tupleRule.getRuleForTuple(nodeTuple);
            if (rule instanceof ContextPathAware) {
                ((ContextPathAware)((Object)rule)).setContextPath(this.contextPath);
            }
            if (rule instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)((Object)rule)).setResourceLoader(this.resourceLoader);
            }
        } else {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        this.ruleContext.push(rule);
        return true;
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
        NodeRule<?> peek = this.ruleContext.peek();
        if (!(peek instanceof SequenceRule)) {
            this.ruleContext.push(peek);
        } else {
            this.ruleContext.push(((SequenceRule)((Object)peek)).getItemRule());
        }
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
        NodeRule<?> rule = this.ruleContext.pop();
        List<ValidationResult> validationResults = rule.onRuleEnd();
        this.addMessages(validationResults);
    }

    @Override
    public void onCustomTagStart(Tag tag2, Node originalValueNode, Node node) {
    }

    @Override
    public void onCustomTagEnd(Tag tag2, Node originalValueNode, Node node) {
    }

    @Override
    public void onCustomTagError(Tag tag2, Node node, String message) {
        this.addMessages(Arrays.asList(ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark())));
    }

    private DefaultTupleRule<Node, MappingNode> buildDocumentRule() {
        return this.nodeRuleFactory.createDocumentRule(this.documentClass);
    }

    @Override
    public List<ValidationResult> getMessages() {
        return this.messages;
    }

    @Override
    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public ContextPath getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

