/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.api.DocumentationItem;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Trait;
import org.raml.v2.api.model.v10.resources.ResourceType;
import org.raml.v2.api.model.v10.security.SecurityScheme;

public class RamlModelResult {
    private List<ValidationResult> validationResults = new ArrayList<ValidationResult>();
    private Api apiV10;
    private org.raml.v2.api.model.v08.api.Api apiV08;
    private Library library;
    private TypeDeclaration typeDeclaration;
    private SecurityScheme securityScheme;
    private Trait trait;
    private ResourceType resourceType;
    private ExampleSpec exampleSpec;
    private DocumentationItem documentationItem;

    RamlModelResult(List<ValidationResult> validationResults) {
        if (validationResults == null || validationResults.isEmpty()) {
            throw new IllegalArgumentException("validationResults cannot be null or emtpy");
        }
        this.validationResults = validationResults;
    }

    RamlModelResult(Api apiV10) {
        if (apiV10 == null) {
            throw new IllegalArgumentException("apiV10 cannot be null");
        }
        this.apiV10 = apiV10;
    }

    RamlModelResult(org.raml.v2.api.model.v08.api.Api apiV08) {
        if (apiV08 == null) {
            throw new IllegalArgumentException("apiV10 cannot be null");
        }
        this.apiV08 = apiV08;
    }

    RamlModelResult(Library library) {
        if (library == null) {
            throw new IllegalArgumentException("library cannot be null");
        }
        this.library = library;
    }

    public RamlModelResult(TypeDeclaration typeDeclaration) {
        if (typeDeclaration == null) {
            throw new IllegalStateException("typeDeclaration cannot be null");
        }
        this.typeDeclaration = typeDeclaration;
    }

    public RamlModelResult(SecurityScheme securityScheme) {
        if (securityScheme == null) {
            throw new IllegalStateException("securityScheme cannot be null");
        }
        this.securityScheme = securityScheme;
    }

    public RamlModelResult(DocumentationItem documentationItem) {
        if (documentationItem == null) {
            throw new IllegalStateException("documentationItem cannot be null");
        }
        this.documentationItem = documentationItem;
    }

    public RamlModelResult(Trait trait) {
        if (trait == null) {
            throw new IllegalStateException("trait cannot be null");
        }
        this.trait = trait;
    }

    public RamlModelResult(ResourceType resourceType2) {
        if (resourceType2 == null) {
            throw new IllegalStateException("resourceType cannot be null");
        }
        this.resourceType = resourceType2;
    }

    public RamlModelResult(ExampleSpec exampleSpec) {
        if (exampleSpec == null) {
            throw new IllegalStateException("exampleSpec cannot be null");
        }
        this.exampleSpec = exampleSpec;
    }

    public boolean hasErrors() {
        return !this.validationResults.isEmpty();
    }

    public boolean isVersion10() {
        return !this.hasErrors() && this.apiV08 == null;
    }

    public boolean isVersion08() {
        return this.apiV08 != null;
    }

    @Nonnull
    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    @Nullable
    public Api getApiV10() {
        return this.apiV10;
    }

    @Nullable
    public org.raml.v2.api.model.v08.api.Api getApiV08() {
        return this.apiV08;
    }

    @Nullable
    public Library getLibrary() {
        return this.library;
    }

    @Nullable
    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    @Nullable
    public SecurityScheme getSecurityScheme() {
        return this.securityScheme;
    }

    @Nullable
    public Trait getTrait() {
        return this.trait;
    }

    @Nullable
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public ExampleSpec getExampleSpec() {
        return this.exampleSpec;
    }

    @Nullable
    public DocumentationItem getDocumentationItem() {
        return this.documentationItem;
    }

    @Nullable
    public RamlFragment getFragment() {
        if (this.hasErrors() || this.isVersion08()) {
            return null;
        }
        if (this.getApiV10() != null) {
            return RamlFragment.Default;
        }
        if (this.getLibrary() != null) {
            return RamlFragment.Library;
        }
        if (this.getTypeDeclaration() != null) {
            return RamlFragment.DataType;
        }
        if (this.getSecurityScheme() != null) {
            return RamlFragment.SecurityScheme;
        }
        if (this.getTrait() != null) {
            return RamlFragment.Trait;
        }
        if (this.getResourceType() != null) {
            return RamlFragment.ResourceType;
        }
        if (this.getExampleSpec() != null) {
            return RamlFragment.NamedExample;
        }
        if (this.getDocumentationItem() != null) {
            return RamlFragment.DocumentationItem;
        }
        throw new IllegalStateException("Fragment not yet supported");
    }
}

