/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons;

import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNodeFragment;
import org.raml.v2.internal.impl.v08.grammar.Raml08Grammar;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.grammar.Raml10GrammarUsesAllowed;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.grammar.rule.Rule;

public class RamlHeader {
    public static final String RAML_HEADER_PREFIX = "#%RAML";
    private RamlVersion version;
    private RamlFragment fragment;

    public RamlHeader(RamlVersion version2, RamlFragment fragment) {
        this.version = version2;
        this.fragment = fragment;
    }

    public RamlHeader(RamlVersion version2) {
        this(version2, null);
    }

    public static RamlHeader parse(String stringContent) throws InvalidHeaderException {
        StringTokenizer lines = new StringTokenizer(StreamUtils.trimBom(stringContent), "\n");
        if (lines.hasMoreElements()) {
            String raml;
            String header = lines.nextToken().trim();
            StringTokenizer headerParts = new StringTokenizer(header);
            if (headerParts.hasMoreTokens() && RAML_HEADER_PREFIX.equals(raml = headerParts.nextToken()) && headerParts.hasMoreTokens()) {
                RamlVersion version2;
                String stringVersion = headerParts.nextToken();
                try {
                    version2 = RamlVersion.parse(stringVersion);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidHeaderVersionException(stringVersion);
                }
                if (version2 == RamlVersion.RAML_10) {
                    String fragmentText = headerParts.hasMoreTokens() ? headerParts.nextToken() : "";
                    RamlFragment fragment = RamlFragment.byName(fragmentText);
                    if (fragment == null) {
                        throw new InvalidHeaderFragmentException(fragmentText);
                    }
                    return new RamlHeader(RamlVersion.RAML_10, fragment);
                }
                return new RamlHeader(RamlVersion.RAML_08);
            }
            throw new InvalidHeaderException(header);
        }
        throw new MissingHeaderException();
    }

    public RamlVersion getVersion() {
        return this.version;
    }

    @Nullable
    public RamlFragment getFragment() {
        return this.fragment;
    }

    @Nullable
    public Rule getRule() {
        if (this.getVersion() == RamlVersion.RAML_08) {
            return new Raml08Grammar().raml();
        }
        return RamlHeader.getFragmentRule(this.fragment);
    }

    @Nullable
    public static Rule getFragmentRule(RamlFragment fragment) {
        Raml10Grammar grammar = new Raml10Grammar();
        return RamlHeader.getRule(fragment, grammar);
    }

    public static Rule getFragmentUsesAllowedRule(RamlFragment fragment) {
        Raml10GrammarUsesAllowed grammar = new Raml10GrammarUsesAllowed();
        return RamlHeader.getRule(fragment, grammar);
    }

    private static Rule getRule(RamlFragment fragment, Raml10Grammar grammar) {
        switch (fragment) {
            case DocumentationItem: {
                return grammar.documentation().with(0, grammar.usesField());
            }
            case DataType: {
                return grammar.explicitType().with(0, grammar.usesField()).then(TypeDeclarationNodeFragment.class);
            }
            case NamedExample: {
                return grammar.exampleFragment();
            }
            case ResourceType: {
                return grammar.resourceType().with(0, grammar.usesField());
            }
            case Trait: {
                return grammar.trait().with(0, grammar.usesField());
            }
            case AnnotationTypeDeclaration: {
                return grammar.annotationTypeDeclaration().with(0, grammar.usesField());
            }
            case Library: {
                return grammar.libraryValue();
            }
            case Overlay: 
            case Extension: {
                return grammar.extension();
            }
            case SecurityScheme: {
                return grammar.securityScheme().with(0, grammar.usesField());
            }
            case Default: {
                return grammar.raml();
            }
        }
        return null;
    }

    public String toString() {
        return "#%RAML " + this.version.value() + (this.fragment != null ? " " + (Object)((Object)this.fragment) : "");
    }

    public static class InvalidHeaderVersionException
    extends InvalidHeaderException {
        public InvalidHeaderVersionException(String version2) {
            super(version2);
        }
    }

    public static class InvalidHeaderFragmentException
    extends InvalidHeaderException {
        public InvalidHeaderFragmentException(String fragmentText) {
            super(fragmentText);
        }
    }

    public static class InvalidHeaderException
    extends Exception {
        public InvalidHeaderException() {
        }

        public InvalidHeaderException(String message) {
            super(message);
        }
    }

    public static class MissingHeaderException
    extends InvalidHeaderException {
    }
}

