/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.HashSet;
import java.util.List;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.util.NodeUtils;

public class TypeValidationPhase
implements Phase {
    @Override
    public Node apply(Node tree) {
        List<TypeDeclarationNode> descendantsWith = tree.findDescendantsWith(TypeDeclarationNode.class);
        for (TypeDeclarationNode typeDeclarationNode : descendantsWith) {
            if (NodeUtils.isErrorResult(typeDeclarationNode) || !this.validateInheritFromValidTypes(typeDeclarationNode)) continue;
            typeDeclarationNode.validateCanOverwrite();
            typeDeclarationNode.validateState();
        }
        return tree;
    }

    private boolean validateInheritFromValidTypes(TypeDeclarationNode typeDeclarationNode) {
        List<TypeExpressionNode> baseTypes = typeDeclarationNode.getBaseTypes();
        HashSet<String> extendedTypes = new HashSet<String>();
        for (TypeExpressionNode baseType : baseTypes) {
            ResolvedType resolvedType = baseType.generateDefinition();
            if (resolvedType == null || resolvedType.getBuiltinTypeName() == null) continue;
            extendedTypes.add(resolvedType.getBuiltinTypeName());
        }
        if (extendedTypes.size() > 1) {
            typeDeclarationNode.replaceWith(ErrorNodeFactory.createCanNotInheritFromDifferentBaseTypes(extendedTypes.toArray(new String[0])));
            return false;
        }
        return true;
    }
}

