/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.emitter.tck;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryRefNode;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNode;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.snakeyaml.SYObjectNode;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;

public class TckEmitter {
    private static final String INDENTATION = "    ";
    private static final String START_MAP = "{";
    private static final String END_MAP = "}";
    private static final String START_ARRAY = "[";
    private static final String END_ARRAY = "]";
    private static final String COMMA_SEP = ",\n";
    private static final String COLON_SEP = ": ";
    private static final String NEWLINE = "\n";

    public String dump(Node raml) {
        int depth = 0;
        StringBuilder dump = new StringBuilder();
        this.dumpObject((ObjectNode)raml, dump, depth);
        this.removeLastSeparator(dump);
        return dump.toString();
    }

    private void dumpNode(Node node, StringBuilder dump, int depth) {
        if (node instanceof ObjectNode) {
            this.dumpObject((ObjectNode)node, dump, depth);
        } else if (node instanceof ArrayNode) {
            this.dumpArray((ArrayNode)node, dump, depth);
        } else if (node instanceof ReferenceNode) {
            this.dumpReference((ReferenceNode)node, dump);
        } else if (node instanceof NullNode) {
            this.dumpNullNode(dump);
        } else if (node instanceof SimpleTypeNode) {
            this.dumpString((SimpleTypeNode)node, dump);
        } else {
            if (node instanceof TypeExpressionNode) {
                return;
            }
            if (node instanceof ErrorNode) {
                throw new RuntimeException("Error node : " + ((ErrorNode)node).getErrorMessage());
            }
            throw new RuntimeException("Unsupported node type: " + node.getClass().getSimpleName());
        }
    }

    private void dumpReference(ReferenceNode node, StringBuilder dump) {
        dump.append(this.sanitizeScalarValue(node.getRefName())).append(COMMA_SEP);
    }

    private void dumpArray(ArrayNode arrayNode, StringBuilder dump, int depth) {
        dump.append(START_ARRAY);
        for (Node node : arrayNode.getChildren()) {
            this.dumpNode(node, dump, depth + 1);
        }
        this.removeLastSeparator(dump);
        dump.append(END_ARRAY).append(COMMA_SEP);
    }

    private void dumpNullNode(StringBuilder dump) {
        dump.append(START_MAP).append(END_MAP).append(COMMA_SEP);
    }

    private void dumpString(SimpleTypeNode node, StringBuilder dump) {
        dump.append(this.sanitizeScalarValue(node.getValue())).append(COMMA_SEP);
    }

    private void dumpObject(ObjectNode objectNode, StringBuilder dump, int depth) {
        ArrayList<KeyValueNode> resourceNodes = new ArrayList<KeyValueNode>();
        ArrayList<KeyValueNode> methodNodes = new ArrayList<KeyValueNode>();
        ArrayList<KeyValueNode> annotationNodes = new ArrayList<KeyValueNode>();
        this.startMap(dump, depth);
        for (Node node : objectNode.getChildren()) {
            if (node instanceof LibraryRefNode) continue;
            if (!(node instanceof KeyValueNode)) {
                throw new RuntimeException("Expecting KeyValueNode got " + node + " on " + objectNode);
            }
            if (node instanceof ResourceNode) {
                resourceNodes.add((ResourceNode)node);
                continue;
            }
            if (node instanceof MethodNode) {
                methodNodes.add((MethodNode)node);
                continue;
            }
            if (node instanceof AnnotationNode) {
                annotationNodes.add((AnnotationNode)node);
                continue;
            }
            this.dumpKeyValueNode(dump, depth, (KeyValueNode)node);
        }
        this.dumpCustomArrayIfPresent(dump, depth + 1, methodNodes, "methods", "method");
        this.dumpCustomArrayIfPresent(dump, depth + 1, resourceNodes, "resources", "relativeUri");
        this.dumpAnnotationsIfPresent(dump, depth + 1, annotationNodes);
        this.removeLastSeparator(dump);
        dump.append(this.addNewline(dump)).append(this.indent(depth)).append(END_MAP).append(COMMA_SEP);
    }

    private void dumpAnnotationsIfPresent(StringBuilder dump, int depth, List<KeyValueNode> annotationNodes) {
        if (!annotationNodes.isEmpty()) {
            dump.append(this.addNewline(dump)).append(this.indent(depth)).append(this.sanitizeScalarValue("annotations")).append(COLON_SEP).append(START_MAP).append(NEWLINE).append(this.indent(depth + 1));
            for (KeyValueNode node : annotationNodes) {
                String key = node.getKey().toString();
                KeyValueNodeImpl copy = new KeyValueNodeImpl(new StringNodeImpl(key.substring(1, key.length() - 1)), node.getValue());
                this.dumpKeyValueNode(dump, depth, copy);
            }
            this.removeLastSeparator(dump);
            dump.append(this.addNewline(dump)).append(this.indent(depth)).append(END_MAP).append(COMMA_SEP);
        }
    }

    private void dumpCustomArrayIfPresent(StringBuilder dump, int depth, List<KeyValueNode> keyValueNodes, String key, String innerKey) {
        if (!keyValueNodes.isEmpty()) {
            dump.append(this.addNewline(dump)).append(this.indent(depth)).append(this.sanitizeScalarValue(key)).append(COLON_SEP).append(START_ARRAY).append(NEWLINE).append(this.indent(depth + 1));
            for (KeyValueNode node : keyValueNodes) {
                Node copy = this.copy(node.getValue());
                copy.addChild(0, new KeyValueNodeImpl(new StringNodeImpl(innerKey), node.getKey()));
                this.dumpObject((ObjectNode)copy, dump, depth + 1);
            }
            this.removeLastSeparator(dump);
            dump.append(this.addNewline(dump)).append(this.indent(depth)).append(END_ARRAY).append(COMMA_SEP);
        }
    }

    private void dumpKeyValueNode(StringBuilder dump, int depth, KeyValueNode node) {
        String keyText = this.sanitizeScalarValue(node.getKey());
        dump.append(this.addNewline(dump)).append(this.indent(depth + 1)).append(keyText).append(COLON_SEP);
        this.dumpNode(node.getValue(), dump, depth + 1);
    }

    private Node copy(Node node) {
        node = node instanceof NullNode ? new SYObjectNode(new MappingNode(Tag.MAP, new ArrayList<NodeTuple>(), DumperOptions.FlowStyle.AUTO), node.getStartPosition().getResourceLoader(), node.getStartPosition().getPath()) : node.copy();
        return node;
    }

    private void startMap(StringBuilder dump, int depth) {
        if (dump.toString().endsWith(COMMA_SEP)) {
            dump.append(this.indent(depth));
        }
        dump.append(START_MAP).append(NEWLINE);
    }

    private void removeLastSeparator(StringBuilder dump) {
        if (dump.toString().endsWith(COMMA_SEP)) {
            int dumpLength = dump.length();
            dump.delete(dumpLength - COMMA_SEP.length(), dumpLength);
        }
    }

    private String indent(int depth) {
        return StringUtils.repeat(INDENTATION, depth);
    }

    private String addNewline(StringBuilder dump) {
        return dump.toString().endsWith(NEWLINE) ? "" : NEWLINE;
    }

    private String sanitizeScalarValue(Object value) {
        if (value instanceof BigDecimal) {
            return this.jsonEscape(((BigDecimal)value).stripTrailingZeros().toString());
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        return this.jsonEscape(String.valueOf(value));
    }

    private String jsonEscape(String text) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.disableDefaultTyping();
            return objectMapper.writeValueAsString(text);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

