/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v08;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.nodes.RamlVersionAnnotation;
import org.raml.v2.internal.impl.commons.phase.DuplicatedPathsTransformer;
import org.raml.v2.internal.impl.commons.phase.IncludeResolver;
import org.raml.v2.internal.impl.commons.phase.RemoveTopLevelSequencesTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsTransformer;
import org.raml.v2.internal.impl.commons.phase.SchemaValidationTransformer;
import org.raml.v2.internal.impl.commons.phase.StringTemplateExpressionTransformer;
import org.raml.v2.internal.impl.v08.grammar.Raml08Grammar;
import org.raml.v2.internal.impl.v08.phase.ReferenceResolverTransformerV08;
import org.raml.v2.internal.impl.v10.phase.MediaTypeInjectionPhase;
import org.raml.v2.internal.utils.RamlNodeUtils;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.NodeParser;
import org.raml.yagi.framework.phase.GrammarPhase;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;

public class Raml08Builder {
    public Node build(String stringContent, ResourceLoader resourceLoader, String resourceLocation, int maxPhaseNumber) throws IOException {
        Node rootNode = NodeParser.parse(resourceLoader, resourceLocation, stringContent);
        List<Phase> phases = this.createPhases(resourceLoader);
        for (int i = 0; i < phases.size(); ++i) {
            Phase phase;
            if (i >= maxPhaseNumber || !RamlNodeUtils.isErrorResult(rootNode = (phase = phases.get(i)).apply(rootNode))) continue;
            return rootNode;
        }
        rootNode.annotate(new RamlVersionAnnotation(RamlVersion.RAML_08));
        return rootNode;
    }

    private List<Phase> createPhases(ResourceLoader resourceLoader) {
        TransformationPhase includesAndParmeters = new TransformationPhase(new IncludeResolver(resourceLoader), new StringTemplateExpressionTransformer());
        TransformationPhase removeSequences = new TransformationPhase(new RemoveTopLevelSequencesTransformer());
        Raml08Grammar raml08Grammar = new Raml08Grammar();
        GrammarPhase grammar = new GrammarPhase(raml08Grammar.raml());
        TransformationPhase referenceCheck = new TransformationPhase(new ReferenceResolverTransformerV08());
        TransformationPhase traitsAndResourceTypes = new TransformationPhase(new ResourceTypesTraitsTransformer(raml08Grammar));
        TransformationPhase duplicatePaths = new TransformationPhase(new DuplicatedPathsTransformer());
        MediaTypeInjectionPhase mediaTypeInjection = new MediaTypeInjectionPhase();
        TransformationPhase schemaValidationPhase = new TransformationPhase(new SchemaValidationTransformer(resourceLoader));
        return Arrays.asList(includesAndParmeters, grammar, removeSequences, referenceCheck, traitsAndResourceTypes, duplicatePaths, mediaTypeInjection, schemaValidationPhase);
    }
}

