/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.AbstractReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.LibraryNodeProvider;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class LibraryRefNode
extends AbstractReferenceNode {
    private String name;

    public LibraryRefNode(String name) {
        this.name = name;
    }

    public LibraryRefNode(LibraryRefNode node) {
        super(node);
        this.name = node.name;
    }

    @Override
    public String getRefName() {
        return this.name;
    }

    @Override
    @Nullable
    public Node resolveReference() {
        Node node = this.selectLibraryLinkNode();
        if (node == null) {
            return null;
        }
        if (node instanceof LibraryLinkNode) {
            return ((LibraryLinkNode)node).getRefNode();
        }
        return null;
    }

    @Nullable
    protected Node selectLibraryLinkNode() {
        for (Node contextNode : this.getContextNodes()) {
            if (contextNode instanceof LibraryNodeProvider) {
                Node libraryNode = ((LibraryNodeProvider)((Object)contextNode)).getLibraryNode();
                Node node = NodeSelector.selectFrom(this.name, libraryNode);
                if (node == null) continue;
                return node;
            }
            Node node = NodeSelector.selectFrom("uses/" + this.name, contextNode);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    @Nonnull
    public Node copy() {
        return new LibraryRefNode(this);
    }
}

