/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.google.common.base.CaseFormat;
import org.raml.v2.internal.utils.InflectorBase;

public class Inflector {
    public static String singularize(String word) {
        return InflectorBase.singularize(word);
    }

    public static String pluralize(String word) {
        return InflectorBase.pluralize(word);
    }

    public static String uppercase(String word) {
        return word.toUpperCase();
    }

    public static String lowercase(String word) {
        return word.toLowerCase();
    }

    public static String lowercamelcase(String word) {
        return Inflector.convert(word, CaseFormat.LOWER_CAMEL);
    }

    public static String uppercamelcase(String word) {
        return Inflector.convert(word, CaseFormat.UPPER_CAMEL);
    }

    public static String lowerunderscorecase(String word) {
        return Inflector.convert(word, CaseFormat.LOWER_UNDERSCORE);
    }

    public static String upperunderscorecase(String word) {
        return Inflector.convert(word, CaseFormat.UPPER_UNDERSCORE);
    }

    public static String lowerhyphencase(String word) {
        return Inflector.convert(word, CaseFormat.LOWER_HYPHEN);
    }

    public static String upperhyphencase(String word) {
        String convert2 = Inflector.convert(word, CaseFormat.UPPER_UNDERSCORE);
        return convert2.replace("_", "-");
    }

    private static String convert(String word, CaseFormat format) {
        word = Inflector.normalize(word);
        return Inflector.detectFormat(word).to(format, word);
    }

    private static String normalize(String word) {
        return word.replace("-", "_");
    }

    private static CaseFormat detectFormat(String word) {
        boolean allUpper = word.toUpperCase().equals(word);
        boolean allLower = word.toLowerCase().equals(word);
        boolean mixedCase = !allUpper && !allLower;
        boolean firstCapital = word.substring(0, 1).toUpperCase().equals(word.substring(0, 1));
        if (mixedCase) {
            if (firstCapital) {
                return CaseFormat.UPPER_CAMEL;
            }
            return CaseFormat.LOWER_CAMEL;
        }
        if (allUpper) {
            return CaseFormat.UPPER_UNDERSCORE;
        }
        return CaseFormat.LOWER_UNDERSCORE;
    }
}

