/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.v2.internal.utils.xml.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResourceResolver
implements LSResourceResolver {
    private final String resourcePath;
    private final ResourceLoader resourceLoader;

    public XsdResourceResolver(ResourceLoader resourceLoader, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.resourcePath = resourcePath;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        byte[] content;
        if (systemId == null || systemId.startsWith("http://") || systemId.startsWith("https://") || systemId.startsWith("file:")) {
            return null;
        }
        if (Paths.get(systemId, new String[0]).normalize().isAbsolute()) {
            return null;
        }
        InputStream inputStream = this.resourceLoader.fetchResource(systemId);
        if (inputStream == null) {
            return null;
        }
        try {
            content = IOUtils.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new LSInputImpl(publicId, systemId, baseURI, new ByteArrayInputStream(content), StreamUtils.detectEncoding(content));
    }
}

