/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.NullNodeImpl;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.ParsingContextType;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeUtils;

public class ArrayRule
extends Rule {
    private Rule of;
    private boolean strict = false;

    public ArrayRule(Rule of) {
        this.of = of;
    }

    public ArrayRule(Rule of, boolean strict) {
        this.of = of;
        this.strict = strict;
    }

    public Rule of() {
        return this.of;
    }

    public void of(Rule of) {
        this.of = of;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        NullNodeImpl nullNode = new NullNodeImpl();
        node.addChild(nullNode);
        List<Suggestion> suggestions = this.of.getSuggestions(nullNode, context);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Suggestion suggestion : suggestions) {
            if (node instanceof ArrayNode && !((ArrayNode)node).isJsonStyle()) {
                result.add(suggestion);
                continue;
            }
            if (context.getContextType() == ParsingContextType.VALUE) {
                String prefix = "\n" + NodeUtils.computeColumnForChild(node.getParent());
                result.add(suggestion.withValue("- " + suggestion.getValue()).withPrefix(prefix));
                continue;
            }
            result.add(suggestion.withValue("- " + suggestion.getValue()));
        }
        return result;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        if (pathToRoot.isEmpty()) {
            return Collections.emptyList();
        }
        Node mappingNode = pathToRoot.get(0);
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(mappingNode, context);
            }
        }
        return this.of.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
    }

    public List<Rule> getChildren() {
        return Collections.singletonList(this.of);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        boolean matches = node instanceof ArrayNode;
        if (matches && this.strict) {
            for (Node child : node.getChildren()) {
                if (this.of.matches(child)) continue;
                return false;
            }
        }
        return matches;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.Array);
        }
        Node result = this.createNodeUsingFactory(node, new Object[0]);
        List<Node> children = node.getChildren();
        for (Node child : children) {
            if (this.of.matches(child)) {
                Node transform2 = this.of.apply(child);
                child.replaceWith(transform2);
                continue;
            }
            child.replaceWith(ErrorNodeFactory.createInvalidArrayElement(child));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Array[" + this.of.getDescription() + "]";
    }
}

