/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.ConditionalRules;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.ExclusiveKeys;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.NullNode;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.ParsingContextType;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.util.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectRule
extends Rule {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<KeyValueRule> fields = new ArrayList<KeyValueRule>();
    @Nullable
    private ConditionalRules conditionalRules;
    private ExclusiveKeys exclusiveKeys;
    private boolean strict = false;
    private boolean allowsAdditionalProperties = false;
    private String discriminatorName;

    public ObjectRule() {
    }

    @Override
    public List<? extends Rule> getChildren() {
        ArrayList<? extends Rule> children = new ArrayList<Rule>();
        children.addAll(this.fields);
        if (this.conditionalRules != null) {
            children.addAll(this.conditionalRules.getChildren());
        }
        return children;
    }

    public ObjectRule(boolean strict) {
        this();
        this.strict = strict;
    }

    @Override
    public ObjectRule named(String ruleName) {
        super.named(ruleName);
        return this;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        List<KeyValueRule> fieldRules = node instanceof NullNode ? this.fields : this.getAllFieldRules(node);
        for (KeyValueRule rule : fieldRules) {
            if (!rule.repeated() && this.findMatchingNode(rule, node.getChildren()) != null) continue;
            if (context.getContextType() == ParsingContextType.VALUE) {
                List<Suggestion> keySuggestions = rule.getKeySuggestions(node, context);
                Node editing = NodeUtils.searchNodeAt(NodeUtils.traverseToRoot(node), context.getLocation());
                String prefix = "\n" + NodeUtils.computeColumnForChild(editing instanceof NullNode ? editing.getParent() : editing);
                for (Suggestion keySuggestion : keySuggestions) {
                    result.add(keySuggestion.withPrefix(prefix));
                }
                continue;
            }
            result.addAll(rule.getKeySuggestions(node, context));
        }
        return result;
    }

    @Nullable
    private Node findMatchingNode(KeyValueRule rule, List<Node> children) {
        for (Node child : children) {
            if (!rule.matches(child) || !this.matchesKey(child, rule) || !this.matchesValue(child, rule)) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        boolean isObjectNode = node instanceof ObjectNode;
        if (!this.strict) {
            return isObjectNode;
        }
        return isObjectNode && this.allChildrenMatch(node);
    }

    private boolean allChildrenMatch(Node node) {
        List<Node> children = node.getChildren();
        List<KeyValueRule> allFieldRules = this.getAllFieldRules(node);
        HashSet<Node> unmatchedChildren = new HashSet<Node>(children);
        for (KeyValueRule rule : allFieldRules) {
            if (unmatchedChildren.remove(this.findMatchingNode(rule, children)) || !rule.isRequired(node)) continue;
            return false;
        }
        for (Node child : unmatchedChildren) {
            if (!this.childMatchesAnyKey(child, allFieldRules) || this.childMatchesAnyRule(child, allFieldRules)) continue;
            return false;
        }
        return unmatchedChildren.isEmpty() || this.allowsAdditionalProperties;
    }

    private boolean childMatchesAnyKey(Node child, List<KeyValueRule> allFieldRules) {
        for (KeyValueRule rule : allFieldRules) {
            if (!this.matchesKey(child, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean childMatchesAnyRule(Node child, List<KeyValueRule> allFieldRules) {
        for (KeyValueRule rule : allFieldRules) {
            if (!rule.matches(child) || !this.matchesKey(child, rule) || !this.matchesValue(child, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesKey(Node child, KeyValueRule rule) {
        return rule.getKeyRule().matches(child.getChildren().get(0));
    }

    private boolean matchesValue(Node child, KeyValueRule rule) {
        return rule.getValueRule().matches(child.getChildren().get(1));
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.Object);
        }
        List<Node> children = node.getChildren();
        List<KeyValueRule> allFieldRules = this.getAllFieldRules(node);
        ArrayList<KeyValueRule> nonMatchingRules = new ArrayList<KeyValueRule>(allFieldRules);
        for (Node child : children) {
            Rule matchingRule = this.findMatchingRule(allFieldRules, child);
            if (matchingRule != null) {
                nonMatchingRules.remove(matchingRule);
                Node newChild = matchingRule.apply(child);
                child.replaceWith(newChild);
                continue;
            }
            if (this.allowsAdditionalProperties) continue;
            Collection<String> options = Collections2.transform(allFieldRules, new Function<KeyValueRule, String>(){

                @Override
                public String apply(KeyValueRule rule) {
                    return rule.getKeyRule().getDescription();
                }
            });
            child.replaceWith(ErrorNodeFactory.createUnexpectedKey(((KeyValueNode)child).getKey(), new TreeSet<String>(options)));
        }
        for (KeyValueRule rule : nonMatchingRules) {
            if (this.discriminatorName == null) {
                if (rule.isRequired(node)) {
                    node.addChild(ErrorNodeFactory.createRequiredValueNotFound(node, rule.getKeyRule()));
                    continue;
                }
                rule.applyDefault(node);
                continue;
            }
            if (rule.isRequired(node)) {
                if (rule.getKeyRule() instanceof StringValueRule && ((StringValueRule)rule.getKeyRule()).getValue().equals(this.discriminatorName)) {
                    node.replaceWith(ErrorNodeFactory.createInvalidType("discriminator not specified"));
                    continue;
                }
                node.addChild(ErrorNodeFactory.createRequiredValueNotFound(node, rule.getKeyRule()));
                continue;
            }
            rule.applyDefault(node);
        }
        this.validateKeysUnique(node);
        this.validateExclusiveKeys(node);
        return this.getResult(node);
    }

    private void validateKeysUnique(Node node) {
        List<Node> children = node.getChildren();
        HashSet<String> gotcha = new HashSet<String>();
        for (Node child : children) {
            if (child instanceof KeyValueNode) {
                String key = ((KeyValueNode)child).getKey().toString();
                if (gotcha.contains(key)) {
                    child.replaceWith(new ErrorNode("Duplicated key '" + key + "'"));
                    continue;
                }
                gotcha.add(key);
                continue;
            }
            if (child instanceof ErrorNode) continue;
            this.logger.error("Child '" + child + "' not a key value node");
        }
    }

    private void validateExclusiveKeys(Node node) {
        if (this.exclusiveKeys != null) {
            boolean hasMatchedRule = false;
            List<Node> children = node.getChildren();
            List<Rule> keys = this.exclusiveKeys.getAllRules();
            block0: for (Node child : children) {
                for (Rule rule : keys) {
                    Node key;
                    if (!(child instanceof KeyValueNode) || !rule.matches(key = ((KeyValueNodeImpl)child).getKey())) continue;
                    if (!hasMatchedRule) {
                        hasMatchedRule = true;
                        continue;
                    }
                    String firstRule = keys.get(0).getDescription();
                    String secondRule = keys.get(1).getDescription();
                    child.replaceWith(ErrorNodeFactory.createExclusiveKeys(firstRule, secondRule));
                    continue block0;
                }
            }
        }
    }

    protected Node getResult(Node node) {
        return this.createNodeUsingFactory(node, new Object[0]);
    }

    private List<KeyValueRule> getAllFieldRules(Node node) {
        if (this.conditionalRules != null) {
            ArrayList<KeyValueRule> rules = new ArrayList<KeyValueRule>(this.fields);
            List<KeyValueRule> rulesNode = this.conditionalRules.getRulesNode(node);
            rules.addAll(rulesNode);
            return rules;
        }
        return this.fields;
    }

    @Nullable
    private Rule findMatchingRule(List<? extends Rule> rootRule, Node node) {
        for (Rule rule : rootRule) {
            if (!rule.matches(node)) continue;
            return rule;
        }
        return null;
    }

    @Override
    public ObjectRule then(Class<? extends Node> clazz) {
        super.then(clazz);
        return this;
    }

    @Override
    public ObjectRule then(NodeFactory factory) {
        super.then(factory);
        return this;
    }

    public ObjectRule with(KeyValueRule field2) {
        this.fields.add(field2);
        return this;
    }

    public ObjectRule withAll(KeyValueRule ... fields) {
        if (fields != null) {
            this.fields.addAll(Arrays.asList(fields));
        }
        return this;
    }

    public ObjectRule with(int index, KeyValueRule field2) {
        this.fields.add(index, field2);
        return this;
    }

    public ObjectRule discriminatorName(String name) {
        this.discriminatorName = name;
        return this;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        if (pathToRoot.isEmpty()) {
            return Collections.emptyList();
        }
        Node mappingNode = pathToRoot.get(0);
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(mappingNode, context);
            }
        }
        Node node = pathToRoot.get(1);
        Rule matchingRule = this.findMatchingRule(this.getAllFieldRules(mappingNode), node);
        return matchingRule == null ? Collections.emptyList() : matchingRule.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
    }

    @Override
    public String getDescription() {
        return "Mapping";
    }

    public void additionalProperties(boolean allowsAdditionalProperties) {
        this.allowsAdditionalProperties = allowsAdditionalProperties;
    }

    public ObjectRule with(ConditionalRules conditional) {
        this.conditionalRules = conditional;
        return this;
    }

    public ObjectRule with(ExclusiveKeys exclusive) {
        this.exclusiveKeys = exclusive;
        return this;
    }
}

