/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.raml.yagi.framework.util.DateType;

public class DateUtils {
    private static final String DATE_ONLY_FOUR_DIGITS_YEAR_LENGTH_VALIDATION = "yagi.date_only_four_digits_year_length_validation";
    private static final String DATE_ONLY_FOUR_DIGITS_YEAR_LENGTH_VALIDATION_ALTERNATE = "org.raml.date_only_four_digits_year_length_validation";
    private static final String STRICT_DATES_RFC3339 = "org.raml.dates_rfc3339_validation";
    private static final String STRICT_DATES_RFC2616 = "org.raml.dates_rfc2616_validation";
    public static boolean FOUR_YEARS_VALIDATION = Boolean.parseBoolean(System.getProperty("yagi.date_only_four_digits_year_length_validation", System.getProperty("org.raml.date_only_four_digits_year_length_validation", "true")));
    public static boolean STRICT_DATES_VALIDATION_3339 = Boolean.parseBoolean(System.getProperty("org.raml.dates_rfc3339_validation", "true"));
    public static boolean STRICT_DATES_VALIDATION_2616 = Boolean.parseBoolean(System.getProperty("org.raml.dates_rfc2616_validation", "true"));
    private DateTimeFormatter dateOnlyFormatter;
    private DateTimeFormatter timeOnlyFormatter;
    private DateTimeFormatter dateTimeOnlyFormatterNoMillis;
    private DateTimeFormatter dateTimeOnlyFormatterMillis;
    private DateTimeFormatter rfc3339FormatterMillis;
    private DateTimeFormatter rfc3339FormatterNoMillis;
    private DateTimeFormatter rfc2616Formatter;

    private DateUtils(boolean strictYear, boolean strictDates3339, boolean strictDates2616) {
        this.setFormatters(strictYear, strictDates3339, strictDates2616);
    }

    public static DateUtils createStrictDateUtils() {
        return new DateUtils(true, true, true);
    }

    public static DateUtils createNonStrictDateUtils() {
        return new DateUtils(false, false, false);
    }

    public static DateUtils createFromProperties() {
        return new DateUtils(FOUR_YEARS_VALIDATION, STRICT_DATES_VALIDATION_3339, STRICT_DATES_VALIDATION_2616);
    }

    public void setFormatters(boolean strictYear, boolean strictDates3339, boolean strictDates2616) {
        this.dateOnlyFormatter = this.yearMonthDayFormat(strictYear, strictDates3339).toFormatter();
        this.timeOnlyFormatter = this.timeOnlyFormatter(strictDates3339).toFormatter();
        this.dateTimeOnlyFormatterNoMillis = this.dateTimeFormat(strictYear, strictDates3339).toFormatter();
        this.dateTimeOnlyFormatterMillis = this.dateTimeFormat(strictYear, strictDates3339).appendLiteral(".").appendFractionOfSecond(1, 9).toFormatter();
        this.rfc2616Formatter = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern("EEE, dd MMM ")).append(this.yearFormat(strictYear, strictDates2616).toFormatter()).appendLiteral(' ').append(this.timeOnlyFormatter(strictDates2616).toFormatter()).append(DateTimeFormat.forPattern(" zzz")).toFormatter();
        this.rfc3339FormatterMillis = this.dateTimeFormat(strictYear, strictDates3339).appendLiteral(".").appendFractionOfSecond(1, 9).appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        this.rfc3339FormatterNoMillis = this.dateTimeFormat(strictYear, strictDates3339).appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
    }

    private DateTimeFormatterBuilder yearMonthDayFormat(boolean strictYear, boolean strictDates) {
        if (strictDates) {
            return this.yearFormat(strictYear, strictDates).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2);
        }
        return this.yearFormat(strictYear, strictDates).appendLiteral('-').appendDecimal(DateTimeFieldType.monthOfYear(), 1, 2).appendLiteral('-').appendDecimal(DateTimeFieldType.dayOfMonth(), 1, 2);
    }

    private DateTimeFormatterBuilder dateTimeFormat(boolean strictYear, boolean strictDates) {
        return this.yearMonthDayFormat(strictYear, strictDates).appendLiteral('T').append(this.timeOnlyFormatter(strictDates).toFormatter());
    }

    private DateTimeFormatterBuilder timeOnlyFormatter(boolean strictDates) {
        if (strictDates) {
            return new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2);
        }
        return new DateTimeFormatterBuilder().appendDecimal(DateTimeFieldType.hourOfDay(), 1, 2).appendLiteral(':').appendDecimal(DateTimeFieldType.minuteOfHour(), 1, 2).appendLiteral(':').appendDecimal(DateTimeFieldType.secondOfMinute(), 1, 2);
    }

    public boolean isValidDate(String date, DateType format, String rfc) {
        try {
            switch (format) {
                case date_only: {
                    this.dateOnlyFormatter.parseLocalDate(date);
                    break;
                }
                case time_only: {
                    this.timeOnlyFormatter.parseLocalTime(date);
                    break;
                }
                case datetime_only: {
                    try {
                        this.dateTimeOnlyFormatterNoMillis.parseLocalDateTime(date);
                    }
                    catch (Exception e) {
                        this.dateTimeOnlyFormatterMillis.parseLocalDateTime(date);
                    }
                    break;
                }
                case datetime: {
                    if ("rfc2616".equals(rfc)) {
                        this.rfc2616Formatter.parseLocalDateTime(date);
                        break;
                    }
                    try {
                        this.rfc3339FormatterMillis.parseLocalDateTime(date);
                    }
                    catch (Exception e) {
                        this.rfc3339FormatterNoMillis.parseLocalDateTime(date);
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DateTimeFormatterBuilder yearFormat(boolean strictYear, boolean strictDates) {
        if (strictYear || strictDates) {
            return new DateTimeFormatterBuilder().appendFixedSignedDecimal(DateTimeFieldType.year(), 4);
        }
        return new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern("YYYY"));
    }
}

